/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramViewConformityRule;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.artifacts.TextAnnotation;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.CollapsedPool;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.Pool;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.DataAssociation;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.MessageFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.DataInput;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.DataObject;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.DataOutput;

public class CollaborationPanel extends ProcessPanel{
    


	public CollaborationPanel(int width, int height, boolean isExecutable) {
		super(width, height, isExecutable);
	}
	
	public CollaborationPanel() {
		this(800, 600, false);
	}

	
	@Override
	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		HashSet<Class<? extends IDraggableElement>> acceptedTypes = new HashSet<Class<? extends IDraggableElement>>();
		
		acceptedTypes.add(DraggableProxy.class);

		//CONNECTORS
		acceptedTypes.add(SequenceFlow.class);
		acceptedTypes.add(MessageFlow.class);
		acceptedTypes.add(DataAssociation.class);
				
		//SWIMLANES
		acceptedTypes.add(Pool.class);
		acceptedTypes.add(CollapsedPool.class);
		
		//DATA
		acceptedTypes.add(DataObject.class);
		acceptedTypes.add(DataInput.class);
		acceptedTypes.add(DataOutput.class);
		
		//Artifacts
		acceptedTypes.add(TextAnnotation.class);
		
		return acceptedTypes;
	}
	
	
	@Override
	public HashSet<IDiagramViewConformityRule> getConformityRules() {
		
		if (rules==null){
			
			this.rules = new HashSet<IDiagramViewConformityRule>();
			
		
			DescriptiveCollaborationRules rules = new DescriptiveCollaborationRules(this);
			this.rules.addAll(rules.getRules());
			
			
		
		}
		
		return rules;
	}
	
//	@Override
//	public IDiagramSyntaxModelBuilder getSyntaxModelBuilder() {
//	    if (syntaxModelBuilder==null) {
//	        syntaxModelBuilder = new BPMNCollaborationSyntaxModelBuilder(this);
//	    }
//	    return syntaxModelBuilder;
//	}
	
//	@Override
//    public AbstractUITemplate getFormTemplate() {
//        return formTmpl;
//    }
	
	
}
