/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.AbstractDiagramViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.ParticipantBean;

public class DescriptiveCollaborationRules  {
	
	protected HashSet<IDiagramViewConformityRule> rules;
	protected CollaborationPanel processPanel;
	
	public DescriptiveCollaborationRules(CollaborationPanel collaborationPanel) {
		
		this.rules = new HashSet<IDiagramViewConformityRule>();
		this.processPanel = collaborationPanel;
		
	}
	

	public HashSet<IDiagramViewConformityRule> getRules() {
		
		this.rules.add(new CollaborationMustContainAtLeast2Pools(processPanel));

		
		return rules;
	}
	
	////COLLABORATION MUST CONTAIN AT LEAST 2 POOLS
	public class CollaborationMustContainAtLeast2Pools extends AbstractDiagramViewConformityRule{
		
		private int missingParticipants = 2;
		
		public CollaborationMustContainAtLeast2Pools(IDiagramView diagramView) {
			super(diagramView);
		}
		
		@Override
		public boolean isConform(IDiagramView diagramView) {
			
			int required = 2;
			
			for(IUIElement el:diagramView.getUIElements().values()){
				
				IDiagramElementView elView = (IDiagramElementView) el;
				
				if (elView.getDiagramElement().getModelElement() instanceof IParticipantBean){
					
						if (required>0){
							required--;
						}else{
							break;
						}
					
				}
				
			}
			
			missingParticipants = 2 - required;
			
			
			if (missingParticipants>=2){
				return true;
			}else{
				return false;				
			}

		}

		@Override
		public boolean canResolveNonConformity() {
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "Add "+missingParticipants+ " more participants / pools to actual collaboration";
		}

		@Override
		public String getRuleDescription() {
			return "A collaboration must contain at least two participants / pools";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Not enought participant in collaboration";
		}

		@Override
		public void resolveNonConformity() {

		}
		
		
		
	}
	
	
	

}
