/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementViewFactory;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.events.IDiagramViewHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.ISyntaxModelBuilder;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IContextualNotification;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagram;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IMainModelElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.graphic.DefaultDiagramElementViewFactory;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.graphic.events.DiagramElementViewUpdateEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.graphic.events.DiagramViewUpdateEvent;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Canvas;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainerDefaultHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.palette.IPalette;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanelResizeConfiguration;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.INewUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IRemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.ISelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUnselectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.ContainerDefaultHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Helper;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.UIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableProxy;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DropHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.UIPanelResizeConfiguration;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane.DefaultParticipantEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.swimlane.PoolEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.palette.ProcessPalette;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.BusinessRuleTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.CallActivity;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.DefaultTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.ManualTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.ReceiveTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.ScriptTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.SendTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.ServiceTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.UserTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.artifacts.TextAnnotation;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.CollapsedPool;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.Pool;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.common.CoreBPMNElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.DataAssociation;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.MessageFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.DataInput;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.DataObject;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.data.DataOutput;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.EndMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.EndNoneEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.IntermediateCatchingMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.IntermediateCatchingTimerEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.IntermediateThrowingMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartTimerEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartTopLevelMessageEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartTopLevelNoneEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.TerminateEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways.EventBasedGateway;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways.ExclusiveGateway;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways.ParallelGateway;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNCollaborationDiagram;
import com.ebmwebsourcing.petalsbpm.business.domain.di.impl.BPMNDiagram;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;

/**
 * BPMN Process Panel: can be either descriptive or executable 
 * @author nfleury
 *
 */
public class ProcessPanel extends UIPanel implements IDiagramView,DropHandler{
	
	private Canvas canvas;
	
	private UIPanelResizeConfiguration resizeConfig;
	
	private DefaultDiagramElementViewFactory bpmnelementFactory;
	
	private boolean executableProcess;
	
	//DI MODEL
	protected BPMNDiagram bpmnDiagram;
	//EDITOR MODEL
	private PoolEditorModel editorModel;
	
	//TOP LEVEL MODEL
	private IMainModelElement mainModel;
	
	private ContainerDefaultHandler containerDefaultHandler;
	
	protected IPalette palette;

	
	protected HashSet<IDiagramViewConformityRule> rules;
	
	
	private HashSet<IContextualNotification> contextualNotifications;
	
	
	
	private IModelElement syntaxModel;
	
	public ProcessPanel(int width,int height,boolean isExecutable) {
		super(DOM.createUniqueId());
		
		this.executableProcess = isExecutable;
		
		this.addDropHandler(this);
		
		this.getMainPanel().setPixelSize(width, height);
		
		this.getMainPanel().add(getCanvas());
		
		this.bpmnelementFactory = new DefaultDiagramElementViewFactory(this);
		this.containerDefaultHandler = new ContainerDefaultHandler(this, this);
		this.containerDefaultHandler.attachDefaultHandlers();
		
		this.contextualNotifications = new HashSet<IContextualNotification>();
		
		

		this.addUIPanelHandler(new IUIPanelHandler() {
			
			public void onUnSelectUIElement(
					IUnselectedElementsEvent unselectedElementsEvent) {
				// TODO Auto-generated method stub
				
			}
			
			public void onSelectUIElement(ISelectedElementsEvent selectedElementsEvent) {
				// TODO Auto-generated method stub
				
			}
			
			public void onResizeRequest(IResizeRequestEvent event) {
				
				
				if (event.getIncreaseWidthSize()>0){
					int actualWidth = canvas.getWidth()+event.getIncreaseWidthSize();
					canvas.setWidth(actualWidth);
					resizeConfig.setActualWidth(actualWidth);
				}
				
				if (event.getIncreaseHeightSize()>0){
					int actualHeight = canvas.getHeight()+event.getIncreaseHeightSize(); 
					canvas.setHeight(actualHeight);
					resizeConfig.setActualHeight(actualHeight);
				}
				
				if (event.getDecreaseWidthSize()>0){
					int actualWidth = canvas.getWidth()-event.getDecreaseWidthSize(); 
					canvas.setWidth(actualWidth);
					resizeConfig.setActualWidth(actualWidth);
				}
				
				if (event.getDecreaseHeightSize()>0){
					int actualHeight = canvas.getHeight()-event.getDecreaseHeightSize(); 
					canvas.setHeight(actualHeight);
					resizeConfig.setActualHeight(actualHeight);
				}
				
			}
			
			public void onRemoveUIElement(IRemoveUIElementEvent removeElementEvent) {
				// TODO Auto-generated method stub
				
			}
			
			public void onNewUIElement(INewUIElementEvent newElementEvent) {
				// TODO Auto-generated method stub
				
			}
		});
		
		
		
		////CREATE MARKERS NEEDED FOR CONNECTORS
		//TODO: doesnt work try to see why
//		
//		//sequence flow
//		this.sequenceFlowEndMarker = getCanvas().createMarker("sequenceFlowEnd");
//		Path sequenceFlowArrow = getCanvas().createPath("M 0 1 L 15 6 L 0 11z", 0, 0);
//		sequenceFlowArrow.setFillColour("black");
//		sequenceFlowArrow.getElement().setAttribute("transform", "scale(0.5)");
//		
//		this.sequenceFlowEndMarker.setRefX(7);
//		this.sequenceFlowEndMarker.setRefY(3);
//		this.sequenceFlowEndMarker.appendChild(sequenceFlowArrow);
//
//		this.sequenceFlowEndMarker.setHeight(200);
//		this.sequenceFlowEndMarker.setWidth(200);
//		this.sequenceFlowEndMarker.setOrient("auto");
		
		
		//Set connection x,y adjustment while connected
		Helper.CONNECTOR_INTERSECTIONPOINT_X_ADJUST = 10;
		Helper.CONNECTOR_INTERSECTIONPOINT_Y_ADJUST = 10;
		
	}


	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		HashSet<Class<? extends IDraggableElement>> acceptedTypes = new HashSet<Class<? extends IDraggableElement>>();
		
		acceptedTypes.add(DraggableProxy.class);

		//CONNECTORS
		acceptedTypes.add(SequenceFlow.class);
		acceptedTypes.add(MessageFlow.class);
		acceptedTypes.add(DataAssociation.class);
		
		
		//SWIMLANES
		acceptedTypes.add(CollapsedPool.class); //if added then its a public process
		
		//a private process cannot have more
		//than one pool
		int pools = 0;
		for(IUIElement el:getUIElements().values()){
			
			if (el instanceof Pool){
				pools++;
			}
			if (pools>1) break;
			
		}
		
		
		if (pools<1) acceptedTypes.add(Pool.class);
		
		
		
		//ACTIVITIES
		acceptedTypes.add(DefaultTask.class);
		acceptedTypes.add(CallActivity.class);
		acceptedTypes.add(ServiceTask.class);
		acceptedTypes.add(SendTask.class);
		acceptedTypes.add(ReceiveTask.class);
		acceptedTypes.add(ManualTask.class);
		acceptedTypes.add(UserTask.class);
		acceptedTypes.add(ScriptTask.class);
		acceptedTypes.add(BusinessRuleTask.class);
		
		//EVENTS
		acceptedTypes.add(StartTopLevelNoneEvent.class);
		acceptedTypes.add(StartTopLevelMessageEvent.class);
		acceptedTypes.add(StartTimerEvent.class);
		acceptedTypes.add(IntermediateCatchingMessageEvent.class);
		acceptedTypes.add(IntermediateCatchingTimerEvent.class);
		acceptedTypes.add(IntermediateThrowingMessageEvent.class);
		acceptedTypes.add(EndNoneEvent.class);
		acceptedTypes.add(EndMessageEvent.class);
		acceptedTypes.add(TerminateEvent.class);
		
		
		//GATEWAYS
		acceptedTypes.add(ExclusiveGateway.class);
		acceptedTypes.add(ParallelGateway.class);
		acceptedTypes.add(EventBasedGateway.class);
		
		//DATA
		acceptedTypes.add(DataObject.class);
		acceptedTypes.add(DataInput.class);
		acceptedTypes.add(DataOutput.class);
		
		//ARTIFACTS
		acceptedTypes.add(TextAnnotation.class);
		
		return acceptedTypes;
	}



	
	public Canvas getCanvas() {
		
		if (canvas==null){
		this.canvas = new Canvas(10000, 10000);
		}
		return canvas;
	}

	public void onDropAccepted(IDropAcceptedEvent event) {
		

		//(re)append dropped element to actual svg canvas element
		//otherwise dragged element may stay attached to its previous parent
		if (event.getDraggableElement() instanceof CoreBPMNElement){
			
			SVGElement elGroup = ((CoreBPMNElement)event.getDraggableElement()).getGroup();
			canvas.appendChild(elGroup);
		
		}
		
		
	}
	
	public boolean isExecutableProcess() {
		return executableProcess;
	}
	
	public void onDropRefused(IDropRefusedEvent event) {
		

	}


	
	public void onOut(IOutEvent event) {
		// TODO Auto-generated method stub
		
	}

	public void onOver(IOverEvent event) {
		// TODO Auto-generated method stub
		
	}






	public IDiagram getDiagram() {
		
		if (bpmnDiagram==null){
			bpmnDiagram = GWT.create(BPMNCollaborationDiagram.class);
		}
		
		return bpmnDiagram;
	}


	public IEditorModel getEditorModel() {
		
		if (editorModel==null){
			editorModel = GWT.create(DefaultParticipantEditorModel.class);
		}
		
		return editorModel;
	}


	public IContainerDefaultHandler getContainerDefaultHandler() {
		return containerDefaultHandler;
	}


	public IDiagramElementViewFactory getElementFactory() {
		return bpmnelementFactory;
	}


	public void addUIElement(IDiagramElementView uiElement) {
		super.addUIElement(uiElement);
	}
	

	public IDiagramElementView getUIElementById(String id) {
		return (IDiagramElementView) super.getUIElementById(id);
	}


	public IUIPanelResizeConfiguration getResizeConfiguration() {
		
		
		if (resizeConfig==null){
			
			this.resizeConfig = new UIPanelResizeConfiguration(this);
			this.resizeConfig.setActualHeight(getCanvas().getHeight());
			this.resizeConfig.setActualWidth(getCanvas().getWidth());
			this.resizeConfig.setDecreaseSize(50);
			this.resizeConfig.setIncreaseSize(50);
			this.resizeConfig.setMaxWidth(20000);
			this.resizeConfig.setMaxHeight(20000);
			this.resizeConfig.setMinWidth(10000);
			this.resizeConfig.setMinHeight(10000);
			
			
		}
		
		
		return resizeConfig;
	}


	public String getName() {
		return "Non-Executable Private Process";
	}


	public IPalette getPalette() {
		
		if (palette==null){
			this.palette  = new ProcessPalette(this);
		}
		
		return palette;
	}


	public HashSet<IDiagramViewConformityRule> getConformityRules() {
		
		if (rules==null){
			
			this.rules = new HashSet<IDiagramViewConformityRule>();
			
		
			DescriptiveProcessRules rules = new DescriptiveProcessRules(this);
			this.rules.addAll(rules.getRules());
			
			if (isExecutableProcess()){
				
				ExecutableProcessRules execRule = new ExecutableProcessRules(this);
				
				this.rules.addAll(execRule.getRules());
			}
			
		
		}
		
		return rules;
	}


//	public IDiagramSyntaxModelBuilder getSyntaxModelBuilder() {
//		
//		if (syntaxModelBuilder==null){
//			this.syntaxModelBuilder = new BPMNProcessSyntaxModelBuilder(this);
//		}
//		
//		return syntaxModelBuilder;
//	}


	public void addHandler(IDiagramViewHandler handler) {
		handlerManager.addHandler(DiagramViewUpdateEvent.TYPE, handler);
		handlerManager.addHandler(DiagramElementViewUpdateEvent.TYPE, handler);
	}


	public IMainModelElement getMainModel(){
		return this.mainModel;
	}
	
	public void setMainModel(IMainModelElement mainModel){
		this.mainModel = mainModel;
//		this.formTmpl.initMappingPolicies();
	}
	
	


	@Override
	public HashSet<IContextualNotification> getContextualNotifications() {
		return contextualNotifications;
	}


	@Override
	public void setContextualNotification(int x, int y,IContextualNotification notification) {
		
		this.contextualNotifications.add(notification);
		
		//if notification is not yet part of actual panel add it
		if (mainPanel.getWidgetIndex(notification)==-1){
			mainPanel.add(notification.asWidget());
		}
		
		mainPanel.setWidgetPosition(notification.asWidget(), x, y);
		
	}


	@Override
	public ISyntaxModelBuilder getSyntaxModelBuilder() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public void setDiagram(IDiagram diagram) {
		this.bpmnDiagram = (BPMNDiagram) diagram;
	}


	
}
