/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events;

import java.util.HashSet;
import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.activities.TaskMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.artifact.TextAnnotationMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.choreography.ChoreographyTaskMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.connectors.SequenceFlowMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.data.DataObjectMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.EndNoneMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.IntermediateCatchingMessageMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.events.IntermediateThrowingMessageMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.gateways.ExclusiveGatewayMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ChoreographyPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;

public abstract class IntermediateEvent extends Event {

	public IntermediateEvent(ProcessPanel definitionPanel, String id) {
		super(definitionPanel, id);
		this.addDropHandler(this);
	}
	
	
	@Override
	public LinkedHashSet<IHasMenuDragProxy> getDragProxies() {
		LinkedHashSet<IHasMenuDragProxy> dps = new LinkedHashSet<IHasMenuDragProxy>();
		
		//CHOREOGRAPHY
		ChoreographyTaskMenuDragProxy ctdp = new ChoreographyTaskMenuDragProxy(this.getUIPanel());
		ctdp.setLabelVisible(false);
		ctdp.setSmallIcon(true);
		
		//TASK
		TaskMenuDragProxy tdp = new TaskMenuDragProxy(this.getUIPanel());
		tdp.setLabelVisible(false);
		tdp.setSmallIcon(true);
		

		//INTERMEDIATE THROWING
		IntermediateThrowingMessageMenuDragProxy it1 = new IntermediateThrowingMessageMenuDragProxy(getUIPanel());
		it1.setLabelVisible(false);
		it1.setSmallIcon(true);
		
		//INTERMEDIATE CATCHING
		IntermediateCatchingMessageMenuDragProxy ic1 = new IntermediateCatchingMessageMenuDragProxy(getUIPanel());
		ic1.setLabelVisible(false);
		ic1.setSmallIcon(true);		
		
		//GATEWAYS
		ExclusiveGatewayMenuDragProxy gdp = new ExclusiveGatewayMenuDragProxy(getUIPanel());
		gdp.setLabelVisible(false);
		gdp.setSmallIcon(true);
		
		//END EVENTS
		EndNoneMenuDragProxy endNoneDragProxy = new EndNoneMenuDragProxy(getUIPanel());
		endNoneDragProxy.setLabelVisible(false);
		endNoneDragProxy.setSmallIcon(true);
		
		//CONNECTORS
		SequenceFlowMenuDragProxy sdp = new SequenceFlowMenuDragProxy(getUIPanel());
		sdp.setLabelVisible(false);
		sdp.setSmallIcon(true);
		
		//DATA
		DataObjectMenuDragProxy dodp = new DataObjectMenuDragProxy(getUIPanel());
		dodp.setLabelVisible(false);
		dodp.setSmallIcon(true);
		
		//Artifacts
		TextAnnotationMenuDragProxy tamdp = new TextAnnotationMenuDragProxy(getUIPanel());
		tamdp.setLabelVisible(false);
		tamdp.setSmallIcon(true);
		
		if ( (this.getUIPanel() instanceof ChoreographyPanel) == true) dps.add(ctdp);
		if ( (this.getUIPanel() instanceof ChoreographyPanel) == false) dps.add(tdp);
		
		dps.add(gdp);
		dps.add(it1);
		dps.add(ic1);
		dps.add(endNoneDragProxy);
		dps.add(sdp);
		dps.add(tamdp);
		
		if (this instanceof IIntermediateCatchUI){
			if ( (this.getUIPanel() instanceof ChoreographyPanel) == false) dps.add(dodp);
		}
		
		return dps;
	}
	
	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		HashSet<Class<? extends IDraggableElement>> result = new HashSet<Class<? extends IDraggableElement>>();
		 
		result.add(SequenceFlow.class);
		 
		return result;
	}

	
	public void onDropAccepted(IDropAcceptedEvent event) {
		//if a sequence flow is dropped from a HasMenuDragProxy connect  
		if (event.getDraggableElement() instanceof DraggableProxy){
			
			DraggableProxy dp = (DraggableProxy) event.getDraggableElement();
			
			if (dp.getHasDraggableElementProxy() instanceof IHasMenuDragProxy){
				
				IHasMenuDragProxy hmdp = (IHasMenuDragProxy) (dp.getHasDraggableElementProxy());
				
				if (dp.getHasDraggableElementProxy().getIUIElementType()==SequenceFlow.class){
					
					SequenceFlow sf = (SequenceFlow) getUIPanel().getElementFactory().getElement(SequenceFlow.class);
					getUIPanel().addUIElement(sf);
					
					sf.connect((IConnectableElement) hmdp.getContextualMenuSubject(), this);
					
				}
				
			}
			
			
		}
	}

}
