/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Path;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElementDefaulHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.ConnectableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.BPMNElementsPath;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.event.MessageEventEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.event.StartMessageEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.MessageFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.google.gwt.core.client.GWT;

public class StartTopLevelMessageEvent extends StartEvent {
	
	private Path mainPath;

	private MessageEventEditorModel editorModel;
	
	private ConnectableElementDefaultHandlers defaultHandlers;
	

	
	public StartTopLevelMessageEvent(ProcessPanel definitionPanel, String id) {
		super(definitionPanel, id);
		
		this.defaultHandlers	= new ConnectableElementDefaultHandlers(this);
		this.defaultHandlers.attachDefaultHandlers();
		
		this.addDropHandler(this);
	}

	@Override
	protected void init() {
		super.init();
		mainPath = this.getDefinitionPanel().getCanvas().createPath(BPMNElementsPath.EVENT_START_TOPLEVEL_MESSAGE, -15, -15);
		mainPath.setFillColour("white");
		mainPath.setStokeColour("#82c341");
		getGroup().appendChild(mainPath);
		mainPath.translate(-15, -15);
	}
	

	public String getName() {
		return "Start Message Event";
	}

	public IConnectableElementDefaulHandlers getDefaultHandlers() {
		// TODO Auto-generated method stub
		return null;
	}

	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		 HashSet<Class<? extends IDraggableElement>> result = new HashSet<Class<? extends IDraggableElement>>();
		 
		 result.add(MessageFlow.class);
		 
	return result;
	}

	public IEditorModel getEditorModel() {
		
		if (editorModel==null){
			
			this.editorModel = GWT.create(StartMessageEditorModel.class);
			
		}
		
		return editorModel;
	}

	public void onDropAccepted(IDropAcceptedEvent event) {

		if (event.getDraggableElement() instanceof DraggableProxy){
			
			DraggableProxy dp = (DraggableProxy) event.getDraggableElement();
			
			if (dp.getHasDraggableElementProxy() instanceof IHasMenuDragProxy){
				
				IHasMenuDragProxy hmdp = (IHasMenuDragProxy) (dp.getHasDraggableElementProxy());
				
				if (dp.getHasDraggableElementProxy().getIUIElementType()==MessageFlow.class){
				
					MessageFlow mf = (MessageFlow) getUIPanel().getElementFactory().getElement(MessageFlow.class);
					getUIPanel().addUIElement(mf);
					
					mf.connect((IConnectableElement) hmdp.getContextualMenuSubject(), this);
					
				}
				
			}
			
			
		}
	}

	public void onDropRefused(IDropRefusedEvent event) {

	}

	public void onOut(IOutEvent event) {
		// TODO Auto-generated method stub

	}

	public void onOver(IOverEvent event) {
		// TODO Auto-generated method stub

	}






}
