/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.gateways;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.AbstractDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.connector.SequenceFlowEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editor.model.gateway.ExclusiveGatewayEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.SequenceFlow;

public class ExecutableProcessGatewayRules {

	private Gateway gateway;
	
	private HashSet<IDiagramElementViewConformityRule> rules;
	
	public ExecutableProcessGatewayRules(Gateway gateway) {
		
		this.rules = new HashSet<IDiagramElementViewConformityRule>();
		
		this.gateway  = gateway;
		
		if (gateway instanceof ExclusiveGateway){
			this.rules.add(new ExclusiveGatewayOutgoingSequenceFlowsMustBeConditionalAndOneMustBeDefault(gateway));
		}
		
	}
	
	public HashSet<IDiagramElementViewConformityRule> getRules() {
		return rules;
	}
	
	////////////////All Exclusive Gateway outgoing sequence Flows must have a condition and one default
	private class ExclusiveGatewayOutgoingSequenceFlowsMustBeConditionalAndOneMustBeDefault extends AbstractDiagramElementViewConformityRule {

		public ExclusiveGatewayOutgoingSequenceFlowsMustBeConditionalAndOneMustBeDefault(
				IDiagramElementView diagramElementView) {
			super(diagramElementView);
			// TODO Auto-generated constructor stub
		}

		@Override
		public boolean isConform(IDiagramElementView diagramElementView) {
			
			IConnectableElement connectable = (IConnectableElement) diagramElementView;
			
			ExclusiveGatewayEditorModel exclusiveModel = (ExclusiveGatewayEditorModel) diagramElementView.getEditorModel();
			
			if (connectable.getOutgoingConnectors().size()==0) return true;//A rule should check if we have outgoing connectors
			
			if (exclusiveModel.getDefaultSequenceFlow()==null){
				return false;
			}
			

			int found = 0;
			//check that all sequence flows have a condition
			for(IConnector c:connectable.getOutgoingConnectors()){
				
				if (c instanceof SequenceFlow){
					
					SequenceFlow seqFlow = (SequenceFlow) c;
					
					if (seqFlow.getDiagramElement().getModelElement()!=exclusiveModel.getDefaultSequenceFlow()){
						
						SequenceFlowEditorModel m = (SequenceFlowEditorModel) seqFlow.getEditorModel();
						
						if (m.getConditionnalExpression()!=null){
							
							if (m.getConditionnalExpression().equals("")==false){
								
								found++;
								
							}
							
						}
						
					}
					
					
				}

			}
			
			if (found==connectable.getOutgoingConnectors().size()-1){
				return true;
			}
			
			
			//check that the remaining sequence flow is the default one
			
			return false;
		}


		
		
		@Override
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public String getResolveConformityDescription() {
			return "All outgoing sequence flows of an Exclusive Gatewat must have a condition and one of them must be selected as default";
		}

		@Override
		public String getRuleDescription() {
			return "Conditions or default Sequence Flow not set";
		}

		@Override
		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		@Override
		public String getRuleName() {
			return "Invalid outgoing Sequence Flows";
		}

		@Override
		public void resolveNonConformity() {
			// TODO Auto-generated method stub
			
		}
		
		
		
		
	}
	


}
