/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.bpmndiagram.usecase.descriptiveprocess;



import com.ebmwebsourcing.geasytools.diagrameditor.DiagramController;
import com.ebmwebsourcing.geasytools.diagrameditor.helper.designer.DiagramDesigner;
import com.ebmwebsourcing.geasytools.diagrameditor.helper.designer.DiagramElementProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.activities.DefaultTask;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.collaboration.Lane;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.EndNoneEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.StartTopLevelNoneEvent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.events.DescriptiveProcessEventValidationRules.StartEventMustHave1OutgoingSeqFlowAtLeast;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.TaskBean;

public class DescriptiveProcessSimpleUseCase extends DiagramDesigner{

	public DescriptiveProcessSimpleUseCase(DiagramController controller) {
		super(controller);
		
		assert ((ProcessPanel)controller.getDiagramView()).isExecutableProcess()==false : "Use case is only for non-executable process";
		
		DiagramElementProxy<?> start = this.dropElement(StartTopLevelNoneEvent.class,15,100);
		
		this.assertPreviousDropWasAccepted();
		
		//validation should fail on start event as it should be connected with something else;
		start.assertIsNotConformToRule(StartEventMustHave1OutgoingSeqFlowAtLeast.class);
		
		//add some task
		final DiagramElementProxy<TaskBean> task = this.dropElement(DefaultTask.class,200,100);
		
		//change the task name
		task.changePropertyValue("name", "My Task");
		
		this.assertValidationFails();
		
		//connect start event with task
		this.connectElements(start, task, SequenceFlow.class);
		
		//now the start event should be conform to previous checked rule
		start.assertIsConformToRule(StartEventMustHave1OutgoingSeqFlowAtLeast.class);
		
		//drop a lane just to see if drop is admitted
		this.dropElement(Lane.class, 10, 10);
		
		this.assertPreviousDropWasRefused();
		
		DiagramElementProxy<?> end = this.dropElement(EndNoneEvent.class,350,100);
		
		this.connectElements(task, end, SequenceFlow.class);
		
		//there shouldnt be any validation errors anymore
		this.assertValidationDoesNotFail();
		
	}
	

}
