/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petalsbpm.client.component.bpmn;

import java.util.ArrayList;
import java.util.Collection;

import com.ebmwebsourcing.bpmn.deployer.client.to.BPMNFile;
import com.ebmwebsourcing.bpmn.deployer.client.to.ProcessExecutorDescription;
import com.ebmwebsourcing.bpmn.deployer.client.ui.BPMNDeploymentWindow;
import com.ebmwebsourcing.bpmn.petals.deployer.client.PetalsSEBPELDescription;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItemClickHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorFrontController;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.ISaveProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.SaveProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.request.RequestEvent;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNProjectInstance;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.executable.ExecutableBPMNProjectType;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;
import com.gwtext.client.widgets.MessageBox;

public class BPMNDeploymentButtonClickHandler implements IMenuItemClickHandler {

	private IEditorFrontController controller;

	public BPMNDeploymentButtonClickHandler(IEditorFrontController controller) {
		this.controller = controller;
	}

	@Override
	public void onClick() {
		// 1 - get the current project instance
		final BPMNProjectInstance pi = (BPMNProjectInstance) controller.getProjectManager().getActualProjectInstance();

		// 2 - check it is an executable one
		if(!(pi.getProjectType() instanceof ExecutableBPMNProjectType)) {
			MessageBox.alert("Deployment is only possible for executable projects");
			return;
		}

		// 3 - write it on the server if it is not already done or ask the user to save before
		controller.getEventBus().fireEvent(new RequestEvent(new SaveProjectInstanceRequest(pi), new ISaveProjectInstanceResponseHandler() {
			@Override
			public void receiveResponse(IProjectFile result) {
				// 4 - call the deployer window with the definitions, the file address and the PetalsDSBDescription
				BPMNFile bpmnfile = new BPMNFile(result.getAbsolutePath(), pi.getDefinitions());
				Collection<ProcessExecutorDescription> descs = new ArrayList<ProcessExecutorDescription>();
				descs.add(new PetalsSEBPELDescription());
				new BPMNDeploymentWindow(bpmnfile, descs).show();
			}
		}));
	}

}
