/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.collaboration;

import com.ebmwebsourcing.geasytools.webeditor.api.components.IContentPanelComponent;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ui.diagram.CollaborationPanel;
import com.ebmwebsourcing.petalsbpm.client.component.bpmn.ProcessPanelComponent;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.DescriptiveBPMNProjectInstance;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.descriptive.DescriptiveBPMNProjectPlugin;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;

public class DescriptiveBPMNCollaborationPlugin extends DescriptiveBPMNProjectPlugin {

    public DescriptiveBPMNCollaborationPlugin() {
        super(new DescriptiveBPMNCollaborationProjectType());
    }

    @Override
    public IContentPanelComponent getContentPanelComponent(DescriptiveBPMNProjectInstance projectInstance) {
        ProcessPanelComponent c = new ProcessPanelComponent(this,new CollaborationPanel(800, 600, false));
        c.loadProjectInstance(projectInstance);
        return c;
    }


}
