/**
 * bpmn-plugins - Geasy BPMN Editor Plugins - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.descriptive;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.zip.ZipException;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;
import com.ebmwebsourcing.easybox.api.XmlObjectValidator;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.xsd.BPMN20ImportBean;
import com.ebmwebsourcing.petalsbpm.client.plugin.bpmn.BPMNImportProjectInstanceMetaData;
import com.ebmwebsourcing.petalsbpm.server.plugin.bpmn.BPMNFileHelper;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient.ImportAdapter;
import com.ebmwebsourcing.petalsbpm.utils.server.FileHelper;
import com.ebmwebsourcing.petalsbpm.utils.server.ZipHelper;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;
import com.ebmwebsourcing.webeditor.server.impl.service.project.ProjectServiceImpl;
import com.ebmwebsourcing.webeditor.server.impl.service.user.UserServiceImpl;
import com.ebmwebsourcing.webeditor.server.impl.service.webeditor.WebEditorService;
import com.ebmwebsourcing.webeditor.shared.server.api.service.project.IProjectInstanceMetaDataLoader;

public class BPMNImportLoader implements IProjectInstanceMetaDataLoader {

    private static final String prefix = "bpmnImport";
    private static int cpt = 0;
    
    @Override
    public IProjectInstanceMetaData getMetaData(File file, IProjectInstanceFormat format) throws ServiceException {
        File bpmnFile = file;
        
        try {
            if(ZipHelper.getInstance().isZipFile(file)) {
                bpmnFile = getMetaDataFromZip(file, format);
            }
        }
        catch(Exception e) {
            e.printStackTrace();
            return null;
        }
        
        System.out.println("BPMN file : "+bpmnFile);
        
        XmlContext context = new XmlContextFactory().newContext();
        XmlObjectReader reader = context.createReader();
        XmlObjectValidator validator = context.createValidator();
        Definitions defs;
        try {
            defs = reader.readDocument(bpmnFile.toURI().toURL(), Definitions.class);
            validator.failFastValidate(defs);
        } catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        } catch (XmlObjectReadException e) {
            e.printStackTrace();
            return null;
        } catch (XmlObjectValidationException e) {
			e.printStackTrace();
			throw new ServiceException("Invalid BPMN file : "+e.getMessage());
		}
        
        BPMN20ImportBean impt;
        try {
            String location = WebEditorService.ATTACHMENTS_DIR + File.separator + bpmnFile.getName();
            impt = (BPMN20ImportBean) ImportAdapter.adaptBPMNImport(getPrefix(), location, defs);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        BPMNImportProjectInstanceMetaData metaData = new BPMNImportProjectInstanceMetaData(impt);

        return metaData;
    }
    
    private File getMetaDataFromZip(File zipFile, IProjectInstanceFormat format) throws ZipException, IOException {
        File unzipDir = BPMNFileHelper.getOrCreateUnzipDirectory(zipFile);
        ZipHelper.getInstance().unzipFile(zipFile, unzipDir);
        
        File attachedFilesDir = WebEditorService.getInstance().getAttachedFilesDirectory(UserServiceImpl.getInstance().getLoggedUser(),ProjectServiceImpl.getInstance().getCurrentProjectInstance());
        File bpmnFile = BPMNFileHelper.getBPMNFileInList(unzipDir.listFiles());
        
        for(File f : unzipDir.listFiles()) {
            FileHelper.copyFile(f, attachedFilesDir);
        }
        
        return bpmnFile;
    }

    private static String getPrefix() {
        cpt++;
        return prefix+cpt;
    }
    
}
