/**
 * bpmn-petals-deployer - A Web based designer for BPMN 2.0 standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.bpmn.petals.deployer.server;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import com.ebmwebsourcing.bpmn.deployer.client.exception.ProcessExecutorServiceException;
import com.ebmwebsourcing.bpmn.deployer.client.to.RunningProcess;
import com.ebmwebsourcing.bpmn.deployer.server.ProcessExecutorService;
import com.ebmwebsourcing.jbi.bpel.sagenerator.BPELSaGenerator;
import com.ebmwebsourcing.jbi.util.Util;
import com.ebmwebsourcing.petalsbpm.utils.server.FileHelper;
import com.ebmwebsourcing.sa.deployer.ConnectionHelper;
import com.ebmwebsourcing.sa.deployer.PetalsServiceTechnicalException;
import com.ebmwebsourcing.sa.deployer.SADeployer;

public class PetalsSEBPELService implements ProcessExecutorService {

    private static final int DEFAULT_JMX_PORT = 7700;
    private static final String LOGIN = "petals";
    private static final String PASSWORD = "petals";
    
    private static final String SA_NAME_PREFIX = "SA-BPEL-";

    private int port;
    private String host;

    @Override
    public void deployProcess(File processDescriptionFile) throws ProcessExecutorServiceException {
        File sa;
        String saName = SA_NAME_PREFIX+Util.removeExtension(processDescriptionFile.getName());
        try {
            BPELSaGenerator sagenerator = new BPELSaGenerator(processDescriptionFile);
            sa = sagenerator.generateZip(saName, FileHelper.createTemporaryDirectory());
        }
        catch(Throwable t) {
            t.printStackTrace();
            throw new ProcessExecutorServiceException("Could not generate SA : "+t.getMessage());
        }

        try {
            SADeployer.deploySA(host, port, sa.toURI().toURL());
            SADeployer.startSA(host, port, saName);
        }
        catch(Throwable t) {
            t.printStackTrace();
            throw new ProcessExecutorServiceException("Could not deploy SA : "+t.getMessage());
        }
    }

    @Override
    public List<RunningProcess> getRunningProcesses() throws ProcessExecutorServiceException {
        try {
            List<RunningProcess> res = new ArrayList<RunningProcess>();
            Set<String> bpels = SADeployer.getRunningBPELs(host,port).keySet();
            for(String bpel : bpels) {
                res.add(new RunningProcess(bpel, ""));
            }
            return res;
        } catch (PetalsServiceTechnicalException e) {
            e.printStackTrace();
            throw new ProcessExecutorServiceException(e.getMessage());
        }
    }

    @Override
    public void testServiceHost(String host) throws ProcessExecutorServiceException {
        try {
            int index = host.indexOf(':');
            if(index==-1) {
                this.host = host;
                this.port = DEFAULT_JMX_PORT;
            }
            else {
                this.port = Integer.valueOf(host.substring(index+1));
                this.host = host.substring(0,index);
            }
        }
        catch(Throwable t) {
            t.printStackTrace();
            throw new ProcessExecutorServiceException("The host description should be formatted like 'IP' or 'IP:port' ("+host+")");
        }
        if(ConnectionHelper.connect(this.host, this.port, LOGIN, PASSWORD, false)==null) {
            throw new ProcessExecutorServiceException("Could not connect to petals");
        }

        try {
            if(!SADeployer.hasSOAPAndBPELComponents(this.host, this.port)) {
                throw new ProcessExecutorServiceException("The instance of Petals does not have bpel and soap component.");
            }
        } catch (PetalsServiceTechnicalException e) {
            e.printStackTrace();
            throw new ProcessExecutorServiceException("The instance of Petals does not have bpel and soap component.");
        }
    }

    @Override
    public String getHost() {
        return host;
    }

}
