/**
 * sa-deployer - A Web based designer for BPMN 2.0 standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.sa.deployer;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import javax.management.ObjectName;

public class SADeployer {
    
    public static String bpelComponentName = "petals-se-bpel";
    public static String soapComponentName = "petals-bc-soap";
    public static String SA_STARTED_STATE = "Started";
    
    public static final String JMXLogin = "petals";
    public static final String JMXPassword = "petals";
    private static ManagementServiceJMXImpl jmxService;
    
    public static void deploySA(String hostname, Integer port, URL saURL) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
        ManagementServiceJMXImpl service = getJMXService(hostname,port);
        
        System.out.println(service.installServiceAssembly(saURL));
        
        System.out.println(service.getAllEndpoints());
    }
    
    public static void uninstallServiceAssembly(String hostname, Integer port, String saName) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
    	getJMXService(hostname,port).forceUnDeploy(saName);
    }
    
    public static void startSA(String hostname, Integer port, String saName) throws PetalsServiceTechnicalException, PetalsServiceFunctionalException {
    	getJMXService(hostname,port).startServiceAssembly(saName);
    }
    
    public static boolean hasSOAPAndBPELComponents(String hostname, Integer port) throws PetalsServiceTechnicalException {
        boolean soapFound = false;
        boolean bpelFound = false;
        for(ObjectName o : getJMXService(hostname,port).componentsInventory()) {
            if(o.getKeyProperty("name").equals(soapComponentName)) {
                soapFound = true;
            }
            if(o.getKeyProperty("name").equals(bpelComponentName)) {
                bpelFound = true;
            }
            
            if(soapFound && bpelFound) return true;
        }
        
        return false;
    }
    
    public static Map<String, String> getRunningBPELs(String hostname, Integer port) throws PetalsServiceTechnicalException {
        Map<String,String> res = new HashMap<String, String>();
        
        ManagementServiceJMXImpl service = getJMXService(hostname,port);
        String[] sas = service.getComponentServiceAssembly(bpelComponentName);
        for(String sa : sas) {
            //if(state==SA_STARTED_STATE) {
                res.put(sa, "fakeEndpoint");
            //}
        }
        return res;
    }
    
    protected static ManagementServiceJMXImpl getJMXService(String hostname, Integer port) {
        if(jmxService==null || !jmxService.getHostname().equals(hostname) || !jmxService.getPort().equals(port)) {
            jmxService = new ManagementServiceJMXImpl();
            jmxService.setHostname(hostname);
            jmxService.setPort(port);
            jmxService.setJmxClient(ConnectionHelper.connect(hostname, port, JMXLogin, JMXPassword, false));
        }
        return jmxService;
    }
    
}
