/**
 * su-generator - JBI Su Management - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petals.services.generation.cdk5;

import com.ebmwebsourcing.petals.services.generation.JbiBeanDelegate;

/**
 * @author Vincent Zurczak - EBM WebSourcing
 */
public abstract class CdkProvides5BeanDelegate extends JbiBeanDelegate {

	private String timeout, wsdl;
	private Boolean retryPolicy, validateWsdl, forwardSecuritySubject, forwardMessageProperties, forwardAttachments;


	/**
	 * Constructor.
	 * <p>
	 * Must be called by sub-classes.
	 * </p>
	 */
	public CdkProvides5BeanDelegate() {
		super();
		addNamespace( "petalsCDK", "http://petals.ow2.org/components/extensions/version-5" );
	}


	/* (non-Javadoc)
	 * @see com.ebmwebsourcing.jbi.core.jbixml.JbiBeanDelegate#getCdkSection()
	 */
	@Override
	public String getCdkSection() {

		String result = "";

		if( this.timeout != null && ! "0".equals( this.timeout.trim()))
			result += "\t\t\t<petalsCDK:timeout>" + this.timeout + "</petalsCDK:timeout>\n";

		if( this.retryPolicy != null )
			result += "\t\t\t<petalsCDK:retrypolicy>" + this.retryPolicy + "</petalsCDK:retrypolicy>\n";

		if( this.validateWsdl != null )
			result += "\t\t\t<petalsCDK:validate-wsdl>" + this.validateWsdl + "</petalsCDK:validate-wsdl>\n";

		if( this.forwardSecuritySubject != null )
			result += "\t\t\t<petalsCDK:forward-security-subject>" + this.forwardSecuritySubject
			+ "</petalsCDK:forward-security-subject>\n";

		if( this.forwardMessageProperties != null )
			result += "\t\t\t<petalsCDK:forward-message-properties>" + this.forwardMessageProperties
			+ "</petalsCDK:forward-message-properties>\n";

		if( this.forwardAttachments != null )
			result += "\t\t\t<petalsCDK:forward-attachments>" + this.forwardAttachments
			+ "</petalsCDK:forward-attachments>\n";

		if( this.wsdl != null && this.wsdl.trim().length() > 0 )
			result += "\t\t\t<petalsCDK:wsdl>" + this.wsdl + "</petalsCDK:wsdl>\n";

		return result;
	}


	/**
	 * @return the timeout
	 */
	public String getTimeout() {
		return this.timeout;
	}


	/**
	 * @param timeout the timeout to set
	 */
	public void setTimeout( String timeout ) {
		this.timeout = timeout;
	}


	/**
	 * @return the wsdl
	 */
	public String getWsdl() {
		return this.wsdl;
	}


	/**
	 * @param wsdl the wsdl to set
	 */
	public void setWsdl( String wsdl ) {
		this.wsdl = wsdl;
	}


	/**
	 * @return the retryPolicy
	 */
	public Boolean getRetryPolicy() {
		return this.retryPolicy;
	}


	/**
	 * @param retryPolicy the retryPolicy to set
	 */
	public void setRetryPolicy( Boolean retryPolicy ) {
		this.retryPolicy = retryPolicy;
	}


	/**
	 * @return the validateWsdl
	 */
	public Boolean getValidateWsdl() {
		return this.validateWsdl;
	}


	/**
	 * @param validateWsdl the validateWsdl to set
	 */
	public void setValidateWsdl( Boolean validateWsdl ) {
		this.validateWsdl = validateWsdl;
	}


	/**
	 * @return the forwardSecuritySubject
	 */
	public Boolean getForwardSecuritySubject() {
		return this.forwardSecuritySubject;
	}


	/**
	 * @param forwardSecuritySubject the forwardSecuritySubject to set
	 */
	public void setForwardSecuritySubject( Boolean forwardSecuritySubject ) {
		this.forwardSecuritySubject = forwardSecuritySubject;
	}


	/**
	 * @return the forwardAttachments
	 */
	public Boolean getForwardAttachments() {
		return this.forwardAttachments;
	}


	/**
	 * @param forwardAttachments the forwardAttachments to set
	 */
	public void setForwardAttachments( Boolean forwardAttachments ) {
		this.forwardAttachments = forwardAttachments;
	}


	/**
	 * @return the forwardMessageProperties
	 */
	public Boolean getForwardMessageProperties() {
		return this.forwardMessageProperties;
	}


	/**
	 * @param forwardMessageProperties the forwardMessageProperties to set
	 */
	public void setForwardMessageProperties( Boolean forwardMessageProperties ) {
		this.forwardMessageProperties = forwardMessageProperties;
	}


	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.jbi.core.jbixml.JbiBeanDelegate#isProvides()
	 */
	@Override
	public boolean isProvides() {
		return true;
	}
}
