/**
 * petalsbpm-domain-api - API of Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.collaboration;

import java.util.List;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IParticipantBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.artifact.WithArtifactsBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.foundation.IBaseElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.foundation.IMainElementBean;

public interface ICollaborationBean extends IBaseElementBean, WithArtifactsBean, IMainElementBean {

    public String getName();

    public void setName(String arg0);

    public boolean isClosed();

    public void addParticipant(IParticipantBean arg0);

    public void removeParticipant(IParticipantBean arg0);

    public void setParticipants(List<IParticipantBean> arg0);

    public List<IParticipantBean> getParticipants();

    public List<IFlowElementBean> getFlowNodes();

    public void setClosed(boolean arg0);

    public void addMessageFlow(IMessageFlowBean arg0);

    public void removeMessageFlow(IMessageFlowBean arg0);

    public List<IMessageFlowBean> getMessageFlows();

    public void setMessageFlows(List<IMessageFlowBean> arg0);

    public IFlowElementBean getFlowNode(String arg0);

    //not part of spec
    public void addMessage(IMessageBean message);
    
    public List<IMessageBean> getMessages();
}
