/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.data.IExpressionBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.ISequenceFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.common.FlowElementBean;

public class SequenceFlowBean extends FlowElementBean implements ISequenceFlowBean {

	private IFlowElementBean sourceNode;
	private IFlowElementBean targetNode;
	private IExpressionBean expression;

	public SequenceFlowBean(String id){
		super(id);
	}
	
	protected SequenceFlowBean(){
		super();
	}
	////////////////////////////////////////////
	/////                                  /////
	/////       GETTERS AND SETTERS        /////
	/////                                  /////
	////////////////////////////////////////////
	public IFlowElementBean getSourceNode() {
		return sourceNode;
	}
	public void setSourceNode(IFlowElementBean sourceNode) {
		this.sourceNode = sourceNode;
	}
	public IFlowElementBean getTargetNode() {
		return targetNode;
	}
	public void setTargetNode(IFlowElementBean targetNode) {
		this.targetNode = targetNode;
	}
	public IExpressionBean getExpression() {
		return expression;
	}
	public void setExpression(IExpressionBean expression) {
		this.expression = expression;
	}
	
	@Override
	public String toString() {
		return this.getId()+":"+this.getName();
	}
	
	
}
