/**
 * petalsbpm-domain - Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.choreography;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.choreography.IChoreographyTaskBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.common.IMessageFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.IdGenerator;

public class ChoreographyTaskBean extends ChoreographyActivityBean implements IChoreographyTaskBean{

    private IMessageFlowBean initiatingMessageFlow;
    private IMessageFlowBean returnMessageFlow;
    
    public ChoreographyTaskBean(){
        this(IdGenerator.createUniqueId());
    }
    
    public ChoreographyTaskBean(String id){
        super(id);
    }

    ////////////////////////////////////////////
    /////                                  /////
    /////       GETTERS AND SETTERS        /////
    /////                                  /////
    ////////////////////////////////////////////
    public IMessageFlowBean getInitiatingMessageFlow() {
        return initiatingMessageFlow;
    }
    public void setInitiatingMessageFlow(IMessageFlowBean initiatingMessageFlow) {
        this.initiatingMessageFlow = initiatingMessageFlow;
    }
    public IMessageFlowBean getReturnMessageFlow() {
        return returnMessageFlow;
    }
    public void setReturnMessageFlow(IMessageFlowBean returnMessageFlow) {
        this.returnMessageFlow = returnMessageFlow;
    }
    
}
