/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsbpm.server.service.extension;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.BaseElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExtensionElements;
import com.ebmwebsourcing.easywsdl11.api.element.Input;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.extension.client.ObjectExtension;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.BPELExampleGenerator;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.mock.MockDefinitionsDB;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.DefinitionsHelper;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation.BaseElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.infrastructure.DefinitionsBean;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.clientToServer.ClientToServer;
import com.ebmwebsourcing.petalsbpm.server.service.bpmn2.serverToClient.ServerToClient;
import com.ebmwebsourcing.petalsbpm.server.service.extension.ExtensionBinder;
import com.ebmwebsourcing.petalsbpm.server.service.extension.ExtensionBindingManager;
import com.ebmwebsourcing.petalsbpm.server.service.extension.FakeExtensionBinder;
import com.ebmwebsourcing.petalsbpm.server.service.extension.WSDLInputBean;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class ExtensionBindingManagerTest {
    private String testId1;
    private String testId2;
    private String testId3;

    @Test
    public void testExtensionBindingManager() {
        ExtensionBindingManager manager = new ExtensionBindingManager();
        List l = manager.getBinders();
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((int)1, (int)l.size());
        Assert.assertEquals(FakeExtensionBinder.class, ((ExtensionBinder)l.get(0)).getClass());
    }

    @Test
    public void testObjectExtension() throws Exception {
        DefinitionsBean defsBefore = this.getDefinitionsWithObjectExtensions();
        Definitions defs = ClientToServer.adapt((DefinitionsBean)defsBefore);
        XmlObjectXPathEvaluator xpathEvaluator = defs.getXmlContext().createXPathEvaluator();
        XmlObjectNode xmlObjectNode1 = xpathEvaluator.selectSingleXmlObjectNode((XmlObject)defs, "//*[@id='" + this.testId1 + "']", XmlObjectNode.class);
        BaseElement b1 = (BaseElement)xmlObjectNode1;
        Assert.assertNotNull((Object)b1);
        Assert.assertTrue((boolean)b1.hasExtensionElements());
        ExtensionElements ee1 = b1.getExtensionElements();
        Assert.assertNotNull((Object)ee1.getAnyXmlObjects());
        Assert.assertEquals((int)1, (int)ee1.getAnyXmlObjects().length);
        XmlObject o1 = ee1.getAnyXmlObjects()[0];
        Assert.assertTrue((boolean)(o1 instanceof Input));
        Assert.assertEquals((String)"name1", (String)((Input)o1).getName());
        XmlObjectNode xmlObjectNode2 = xpathEvaluator.selectSingleXmlObjectNode((XmlObject)defs, "//*[@id='" + this.testId2 + "']", XmlObjectNode.class);
        BaseElement b2 = (BaseElement)xmlObjectNode2;
        Assert.assertNotNull((Object)b2);
        Assert.assertTrue((boolean)b2.hasExtensionElements());
        ExtensionElements ee2 = b2.getExtensionElements();
        Assert.assertNotNull((Object)ee2.getAnyXmlObjects());
        Assert.assertEquals((int)1, (int)ee2.getAnyXmlObjects().length);
        XmlObject o2 = ee2.getAnyXmlObjects()[0];
        Assert.assertTrue((boolean)(o2 instanceof Input));
        Assert.assertEquals((String)"name2", (String)((Input)o2).getName());
        XmlObjectNode xmlObjectNode3 = xpathEvaluator.selectSingleXmlObjectNode((XmlObject)defs, "//*[@id='" + this.testId3 + "']", XmlObjectNode.class);
        BaseElement b3 = (BaseElement)xmlObjectNode3;
        Assert.assertNotNull((Object)b3);
        Assert.assertTrue((boolean)b3.hasExtensionElements());
        ExtensionElements ee3 = b3.getExtensionElements();
        Assert.assertNotNull((Object)ee3.getAnyXmlObjects());
        Assert.assertEquals((int)1, (int)ee3.getAnyXmlObjects().length);
        XmlObject o3 = ee3.getAnyXmlObjects()[0];
        Assert.assertTrue((boolean)(o3 instanceof Input));
        Assert.assertEquals((String)"name3", (String)((Input)o3).getName());
        DefinitionsBean defsAfter = ServerToClient.adapt((Definitions)defs);
        b1 = DefinitionsHelper.getInstance().getElementById(defsAfter, this.testId1);
        Assert.assertNotNull((Object)b1.getObjectExtensions());
        Assert.assertEquals((int)1, (int)b1.getObjectExtensions().size());
        ObjectExtension o12 = (ObjectExtension)b1.getObjectExtensions().get(0);
        Assert.assertEquals(WSDLInputBean.class, o12.getClass());
        Assert.assertEquals((String)"name1", (String)((WSDLInputBean)o12).getName());
        BaseElementBean b22 = DefinitionsHelper.getInstance().getElementById(defsAfter, this.testId2);
        Assert.assertNotNull((Object)b22.getObjectExtensions());
        Assert.assertEquals((int)1, (int)b22.getObjectExtensions().size());
        ObjectExtension o22 = (ObjectExtension)b22.getObjectExtensions().get(0);
        Assert.assertEquals(WSDLInputBean.class, o22.getClass());
        Assert.assertEquals((String)"name2", (String)((WSDLInputBean)o22).getName());
        BaseElementBean b32 = DefinitionsHelper.getInstance().getElementById(defsAfter, this.testId3);
        Assert.assertNotNull((Object)b32.getObjectExtensions());
        Assert.assertEquals((int)1, (int)b32.getObjectExtensions().size());
        ObjectExtension o32 = (ObjectExtension)b32.getObjectExtensions().get(0);
        Assert.assertEquals(WSDLInputBean.class, o32.getClass());
        Assert.assertEquals((String)"name3", (String)((WSDLInputBean)o32).getName());
    }

    @Test
    public void testUnsupportedObjectExtension() throws Exception {
        DefinitionsBean defs = this.getDefinitionsWithUnsupportedExtension();
        try {
            ClientToServer.adapt((DefinitionsBean)defs);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail((String)"Should have thrown an exception.");
    }

    private DefinitionsBean getDefinitionsWithObjectExtensions() {
        DefinitionsBean defs = BPELExampleGenerator.getExample();
        this.testId1 = BPELExampleGenerator.LOWER_LANE_ID;
        BaseElementBean b1 = DefinitionsHelper.getInstance().getElementById(defs, this.testId1);
        WSDLInputBean ext1 = new WSDLInputBean("name1");
        b1.addObjectExtension((ObjectExtension)ext1);
        this.testId2 = BPELExampleGenerator.LOWER_LANE_SF_1_ID;
        BaseElementBean b2 = DefinitionsHelper.getInstance().getElementById(defs, this.testId2);
        WSDLInputBean ext2 = new WSDLInputBean("name2");
        b2.addObjectExtension((ObjectExtension)ext2);
        this.testId3 = BPELExampleGenerator.UPPER_LANE_EL_1_ID;
        BaseElementBean b3 = DefinitionsHelper.getInstance().getElementById(defs, this.testId3);
        WSDLInputBean ext3 = new WSDLInputBean("name3");
        b3.addObjectExtension((ObjectExtension)ext3);
        return defs;
    }

    private DefinitionsBean getDefinitionsWithUnsupportedExtension() {
        DefinitionsBean defs = MockDefinitionsDB.getSingleExample();
        BaseElementBean b1 = DefinitionsHelper.getInstance().getElementById(defs, MockDefinitionsDB.LOWER_LANE_EL_9_ID);
        WSDLInputBean ext1 = new WSDLInputBean("name1");
        b1.addObjectExtension((ObjectExtension)ext1);
        BaseElementBean b = DefinitionsHelper.getInstance().getElementById(defs, MockDefinitionsDB.MF_3_ID);
        UnsupportedObjectExtensionBean ext = new UnsupportedObjectExtensionBean();
        b.addObjectExtension((ObjectExtension)ext);
        return defs;
    }

    private class UnsupportedObjectExtensionBean
    implements ObjectExtension {
        private static final long serialVersionUID = 1L;

        private UnsupportedObjectExtensionBean() {
        }
    }
}

