/**
 * petalsbpm-utils - BPMNEditor utils - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.utils.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileHelper {

	/**
	 * Writes the given content in a the file denoted by the given path (creating it if necessary)
	 * @param absolutePath
	 * @param content
	 * @throws IOException 
	 */
    public static void writeFile(String absoluteFilePath, String content) throws IOException {
        File file = new File(absoluteFilePath);
        if(!file.exists()){
            file.createNewFile();
        }
        file.setWritable(true);
        FileOutputStream fos = null;
        try{
            fos = new FileOutputStream(file);
            fos.write(content.getBytes());
        }
        catch(IOException e) {
            throw e;
        }
        finally{
            if(fos!=null) fos.close();
        }
    }
	
	/**
	 * Copies the given file into the given output directory
	 * @param file
	 * @param outputDirectory
	 * @throws IOException 
	 */
	public static void copyFile(File file, File outputDirectory) throws IOException {
	    assert outputDirectory.isDirectory();
	    
	    if(file.isDirectory()) {
	        File dirCopy = new File(outputDirectory+File.separator+file.getName());
	        dirCopy.mkdir();
	        File[] children = file.listFiles();
	        if(children!=null) {
	            for(File child : children) {
	                copyFile(child, dirCopy);
	            }
	        }
	    }
	    else {
	        String path = outputDirectory.getAbsolutePath() + File.separator + file.getName();
	        File copy = new File(path);
	        copy.createNewFile();
	        
	        copyContent(file,copy);
	    }
	}
	
	private static void copyContent(File source, File target) throws IOException {
	    FileInputStream fis  = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(target);
        try {
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        } 
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fis != null) fis.close();
            if (fos != null) fos.close();
        }
	}
	
	/**
	 * Recursively deletes all the children of the directory
	 * @param dir
	 */
	public static void cleanDirectory(File dir){
		if(dir.isDirectory() && dir.listFiles()!=null){
			for(File child : dir.listFiles()){
				recursiveDelete(child);
			}
		}
	}
	
	/**
	 * Recursively deletes the file and its children
	 * @param f
	 */
	public static void recursiveDelete(File f){
		if(f.isDirectory() && f.listFiles()!=null){
			for(File child : f.listFiles()){
				recursiveDelete(child);
			}
		}
		f.delete();
	}
	
	public static String getUsablePath(File dir) {
        return getUsablePath(dir.getAbsolutePath());
    }
	
	public static String getUsablePath(String path) {
	    String result = path;
        if(!result.endsWith(File.separator)){
            result = result + File.separator;
        }
        return result;
	}
	
}
