/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.sla.agreement.descriptor;

import com.ebmwebsourcing.addressing.descriptor.AddressingException;
import com.ebmwebsourcing.addressing.descriptor.Endpoint;
import com.ebmwebsourcing.sla.agreement.descriptor.AgreementDescriptorException;
import com.ebmwebsourcing.sla.agreement.descriptor.Preference;
import com.ebmwebsourcing.sla.agreement.descriptor.QualifyingCondition;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.ggf.schemas.graap._2007._03.ws_agreement.Agreement;
import org.ggf.schemas.graap._2007._03.ws_agreement.AgreementContextType;
import org.ggf.schemas.graap._2007._03.ws_agreement.AgreementRoleType;
import org.ggf.schemas.graap._2007._03.ws_agreement.AgreementTemplate;
import org.ggf.schemas.graap._2007._03.ws_agreement.BusinessValueListType;
import org.ggf.schemas.graap._2007._03.ws_agreement.CompensationType;
import org.ggf.schemas.graap._2007._03.ws_agreement.ConstraintSectionType;
import org.ggf.schemas.graap._2007._03.ws_agreement.GuaranteeTermType;
import org.ggf.schemas.graap._2007._03.ws_agreement.KPITargetType;
import org.ggf.schemas.graap._2007._03.ws_agreement.ObjectFactory;
import org.ggf.schemas.graap._2007._03.ws_agreement.PreferenceType;
import org.ggf.schemas.graap._2007._03.ws_agreement.ServiceDescriptionTermType;
import org.ggf.schemas.graap._2007._03.ws_agreement.ServiceLevelObjectiveType;
import org.ggf.schemas.graap._2007._03.ws_agreement.ServicePropertiesType;
import org.ggf.schemas.graap._2007._03.ws_agreement.ServiceReferenceType;
import org.ggf.schemas.graap._2007._03.ws_agreement.ServiceRoleType;
import org.ggf.schemas.graap._2007._03.ws_agreement.ServiceSelectorType;
import org.ggf.schemas.graap._2007._03.ws_agreement.TermCompositorType;
import org.ggf.schemas.graap._2007._03.ws_agreement.TermTreeType;
import org.ggf.schemas.graap._2007._03.ws_agreement.VariableSetType;
import org.ggf.schemas.graap._2007._03.ws_agreement.VariableType;
import sla.ebmwebsourcing.com.agreementextensions.ReferenceProperties;
import sla.ebmwebsourcing.com.agreementextensions.TExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgreementFactory {
    private static AgreementFactory instance;
    private ObjectFactory jaxbAgreementFactory = new ObjectFactory();
    private sla.ebmwebsourcing.com.agreementextensions.ObjectFactory jaxbAgreementExtensionsFactory = new sla.ebmwebsourcing.com.agreementextensions.ObjectFactory();
    private static int cptEndpointReferenceId;
    private static int cptTemplateId;

    public static AgreementFactory getInstance() {
        if (instance == null) {
            instance = new AgreementFactory();
        }
        return instance;
    }

    public AgreementTemplate agreementTemplateBuilder(String name, AgreementContextType context, TermTreeType terms, ConstraintSectionType constraints) {
        AgreementTemplate res = new AgreementTemplate();
        res.setName(name);
        res.setContext(context);
        res.setTerms(terms);
        res.setCreationConstraints(constraints);
        res.setAgreementId(String.valueOf(++cptEndpointReferenceId));
        res.setTemplateId(String.valueOf(++cptTemplateId));
        return res;
    }

    public Agreement agreementOfferBuilder(String name, AgreementContextType context, TermTreeType terms) {
        Agreement res = new Agreement();
        res.setName(name);
        res.setContext(context);
        res.setTerms(terms);
        res.setAgreementId(String.valueOf(++cptEndpointReferenceId));
        return res;
    }

    public AgreementContextType agreementContextBuilder(Endpoint initiator, Endpoint responder, AgreementRoleType agreementRoleType, XMLGregorianCalendar expirationTime, String templateId, String templateName) throws AddressingException, AgreementDescriptorException {
        AgreementContextType res = new AgreementContextType();
        res.setAgreementInitiator(initiator);
        res.setAgreementResponder(responder);
        res.setServiceProvider(agreementRoleType);
        res.setExpirationTime(expirationTime);
        res.setTemplateId(templateId);
        res.setTemplateName(templateName);
        return res;
    }

    public TermTreeType agreementTermsBuilder(String name, Endpoint service, String providerName, URI wsdlFile, List<VariableType> variablePropertiesMetrics, List<GuaranteeTermType> guarantees) throws AgreementDescriptorException, AddressingException {
        TermTreeType res = new TermTreeType();
        TermCompositorType terms = new TermCompositorType();
        if (name == null) {
            throw new AgreementDescriptorException("the name of ServiceDescriptionTerm cannot be null");
        }
        if (service.getAddress().getValue() == null) {
            throw new AgreementDescriptorException("the serviceName of ServiceDescriptionTerm cannot be null");
        }
        if (wsdlFile == null) {
            throw new AgreementDescriptorException("the wsdlFile of ServiceDescriptionTerm cannot be null");
        }
        terms.getExactlyOneOrOneOrMoreOrAll().add(this.jaxbAgreementFactory.createTermCompositorTypeServiceDescriptionTerm(this.agreementServiceDescriptionTermBuilder(name, service.getAddress().getValue(), providerName, wsdlFile)));
        terms.getExactlyOneOrOneOrMoreOrAll().add(this.jaxbAgreementFactory.createTermCompositorTypeServiceReference(this.agreementServiceReferenceBuilder(name, service)));
        if (variablePropertiesMetrics != null && variablePropertiesMetrics.size() > 0) {
            terms.getExactlyOneOrOneOrMoreOrAll().add(this.jaxbAgreementFactory.createTermCompositorTypeServiceProperties(this.agreementServicePropertiesBuilder(name, service.getAddress().getValue(), variablePropertiesMetrics)));
        }
        for (GuaranteeTermType guarantee : guarantees) {
            terms.getExactlyOneOrOneOrMoreOrAll().add(this.jaxbAgreementFactory.createTermCompositorTypeGuaranteeTerm(guarantee));
        }
        res.setAll(terms);
        return res;
    }

    public ServiceDescriptionTermType agreementServiceDescriptionTermBuilder(String name, String serviceName, String providerName, URI wsdlFile) throws AgreementDescriptorException {
        ServiceDescriptionTermType sdt = new ServiceDescriptionTermType();
        sdt.setName(name);
        sdt.setServiceName(serviceName);
        if (wsdlFile != null) {
            ReferenceProperties rp = new ReferenceProperties();
            rp.setProviderName(providerName);
            rp.setWsdlUri(wsdlFile.toString());
            sdt.setAny(this.jaxbAgreementExtensionsFactory.createReferenceProperties(rp));
        }
        return sdt;
    }

    public ServiceReferenceType agreementServiceReferenceBuilder(String name, Endpoint service) throws AgreementDescriptorException, AddressingException {
        ServiceReferenceType srt = new ServiceReferenceType();
        srt.setName(name);
        if (service != null && service.getAddress() != null) {
            srt.setServiceName(service.getAddress().getValue());
        }
        srt.setAny(service);
        return srt;
    }

    public ServicePropertiesType agreementServicePropertiesBuilder(String name, String serviceName, List<VariableType> variablePropertiesMetric) throws AgreementDescriptorException {
        ServicePropertiesType spt = new ServicePropertiesType();
        spt.setName(name);
        spt.setServiceName(serviceName);
        if (variablePropertiesMetric != null && variablePropertiesMetric.size() > 0) {
            VariableSetType vst = new VariableSetType();
            vst.getVariable().addAll(variablePropertiesMetric);
            spt.setVariableSet(vst);
        }
        return spt;
    }

    public VariableType agreementVariablePropertiesMetric(String name, String metric, String location) {
        VariableType v = new VariableType();
        v.setName(name);
        v.setMetric(metric);
        v.setLocation(location);
        return v;
    }

    public VariableType agreementVariablePropertiesMetric(String name, String metric) {
        VariableType v = new VariableType();
        v.setName(name);
        v.setMetric(metric);
        v.setLocation("");
        return v;
    }

    public GuaranteeTermType agreementGuaranteeTermBuilder(String name, ServiceRoleType obligated, QualifyingCondition qc, ServiceLevelObjectiveType slo, BusinessValueListType business, List<ServiceSelectorType> serviceScope) throws AgreementDescriptorException {
        GuaranteeTermType gt = new GuaranteeTermType();
        gt.setName(name);
        gt.setObligated(obligated);
        if (serviceScope == null) {
            gt.setServiceScope(new ArrayList<ServiceSelectorType>());
        } else {
            gt.setServiceScope(serviceScope);
        }
        if (slo == null) {
            gt.setServiceLevelObjective(new ServiceLevelObjectiveType());
        } else {
            gt.setServiceLevelObjective(slo);
        }
        if (business == null) {
            gt.setBusinessValueList(new BusinessValueListType());
        } else {
            gt.setBusinessValueList(business);
        }
        if (qc != null) {
            TExpression expr = new TExpression();
            expr.setExpressionLanguage(qc.getExpressionLanguage());
            expr.setValue(qc.getCondition());
            gt.setQualifyingCondition(expr);
        }
        return gt;
    }

    public ServiceLevelObjectiveType agreementServiceLevelObjectiveTermBuilder(String kpiName, String value) throws AgreementDescriptorException {
        ServiceLevelObjectiveType slo = new ServiceLevelObjectiveType();
        KPITargetType kpi = new KPITargetType();
        kpi.setKPIName(kpiName);
        TExpression expr = new TExpression();
        expr.setExpressionLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
        expr.setValue(value);
        kpi.setTarget(expr);
        slo.setKPITarget(kpi);
        return slo;
    }

    public BusinessValueListType agreementBusinessValueListBuilder(int importance, List<CompensationType> penalties, List<CompensationType> rewards, List<Preference> preferences) {
        BusinessValueListType bvl = new BusinessValueListType();
        bvl.setImportance(BigInteger.valueOf(importance));
        if (penalties != null) {
            bvl.getPenalty().addAll(penalties);
        }
        if (rewards != null) {
            bvl.getReward().addAll(rewards);
        }
        if (preferences != null) {
            PreferenceType p = new PreferenceType();
            for (Preference preference : preferences) {
                p.getServiceTermReferenceAndUtility().add((Comparable)((Object)preference.getServiceTermReference()));
                p.getServiceTermReferenceAndUtility().add(Float.valueOf(preference.getUtility()));
            }
            bvl.setPreference(p);
        }
        return bvl;
    }

    public CompensationType agreementPenaltyOrRewardBuilder(Duration duration, String unit, Float value) {
        CompensationType c = new CompensationType();
        CompensationType.AssessmentInterval it = new CompensationType.AssessmentInterval();
        it.setTimeInterval(duration);
        c.setAssessmentInterval(it);
        TExpression expr = new TExpression();
        expr.setExpressionLanguage("float");
        expr.setValue(String.valueOf(value));
        c.setValueExpression(expr);
        c.setValueUnit(unit);
        return c;
    }

    public CompensationType agreementPenaltyOrRewardBuilder(long invocationNumber, String unit, Float value) {
        CompensationType c = new CompensationType();
        CompensationType.AssessmentInterval it = new CompensationType.AssessmentInterval();
        it.setCount(BigInteger.valueOf(invocationNumber));
        c.setAssessmentInterval(it);
        TExpression expr = new TExpression();
        expr.setExpressionLanguage("float");
        expr.setValue(String.valueOf(value));
        c.setValueExpression(expr);
        c.setValueUnit(unit);
        return c;
    }

    public ServiceSelectorType agreementServiceSelectorBuilder(String serviceName, String value) {
        ServiceSelectorType res = new ServiceSelectorType();
        res.setServiceName(serviceName);
        ArrayList<ServiceSelectorType.AnyItem> items = new ArrayList<ServiceSelectorType.AnyItem>();
        ServiceSelectorType.AnyItem item = new ServiceSelectorType.AnyItem();
        item.setItem(this.jaxbAgreementExtensionsFactory.createScope(value));
        items.add(item);
        res.setAnyItems(items);
        return res;
    }

    public ObjectFactory getJaxbAgreementFactory() {
        return this.jaxbAgreementFactory;
    }

    public sla.ebmwebsourcing.com.agreementextensions.ObjectFactory getJaxbAgreementExtensionsFactory() {
        return this.jaxbAgreementExtensionsFactory;
    }

    static {
        cptEndpointReferenceId = 0;
        cptTemplateId = 0;
    }
}

