/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.sla.agreement.descriptor.original;

import com.ebmwebsourcing.addressing.descriptor.AddressingException;
import com.ebmwebsourcing.addressing.descriptor.Endpoint;
import com.ebmwebsourcing.sla.agreement.descriptor.AgreementDescriptorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.ggf.schemas.graap._2007._03.ws_agreement.Agreement;
import org.ggf.schemas.graap._2007._03.ws_agreement.GuaranteeTermType;
import org.ggf.schemas.graap._2007._03.ws_agreement.ObjectFactory;
import org.w3._2005._08.addressing.EndpointReferenceType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AgreementDescriptorBuilder {
    public static final String AGREEMENT_NAMESPACE = "http://schemas.ggf.org/graap/2007/03/ws-agreement";
    public static final String XSD_AGREEMENT = "agreement.xsd";
    public static final String XSD_AGREEMENT_EXTENSIONS = "agreementExtensions.xsd";
    private static JAXBContext jaxbContext;
    private static Unmarshaller unmarshaller;
    private static AgreementDescriptorException unmarshallerCreationEx;
    private static Marshaller marshaller;
    private static AgreementDescriptorException marshallerCreationEx;

    private AgreementDescriptorBuilder() {
    }

    public static void validateAgreementDescriptor(InputStream agreementDescriptorStream) throws AgreementDescriptorException {
        Validator validator = AgreementDescriptorBuilder.getUnMarshaller().getSchema().newValidator();
        try {
            validator.validate(new StreamSource(agreementDescriptorStream));
        }
        catch (SAXException e) {
            throw new AgreementDescriptorException("Failed to validate EndpointReference descriptor against Agreement schema", e);
        }
        catch (IOException e) {
            throw new AgreementDescriptorException("Failed to validate EndpointReference descriptor against Agreement schema", e);
        }
    }

    public static Agreement buildJavaAgreementDescriptor(InputStream agreementDescriptorStream) throws AgreementDescriptorException {
        try {
            JAXBElement agreementBinding = AgreementDescriptorBuilder.getUnMarshaller().unmarshal((Source)new StreamSource(agreementDescriptorStream), Agreement.class);
            return (Agreement)agreementBinding.getValue();
        }
        catch (JAXBException e) {
            throw new AgreementDescriptorException("Failed to build Java bindings from Agreement descriptor XML document", e);
        }
    }

    public static JAXBElement<Agreement> buildJavaJAxbAgreementDescriptor(InputStream agreementDescriptorStream) throws AgreementDescriptorException {
        try {
            JAXBElement agreementBinding = AgreementDescriptorBuilder.getUnMarshaller().unmarshal((Source)new StreamSource(agreementDescriptorStream), Agreement.class);
            return agreementBinding;
        }
        catch (JAXBException e) {
            throw new AgreementDescriptorException("Failed to build Java bindings from Agreement descriptor XML document", e);
        }
    }

    public static Element buildXmlAgreementDescriptor(Agreement agreementDescriptor) throws AgreementDescriptorException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            AgreementDescriptorBuilder.getMarshaller().marshal((Object)agreementDescriptor, (Node)doc);
        }
        catch (JAXBException ex) {
            throw new AgreementDescriptorException("Failed to build XML binding from Agreement descriptor Java classes", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new AgreementDescriptorException("Failed to build XML binding from Agreement descriptor Java classes", ex);
        }
        return doc.getDocumentElement();
    }

    public static Element buildXmlGuaranteeDescriptor(GuaranteeTermType guarantee) throws AgreementDescriptorException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            AgreementDescriptorBuilder.getMarshaller().marshal((Object)guarantee, (Node)doc);
        }
        catch (JAXBException ex) {
            throw new AgreementDescriptorException("Failed to build XML binding from Agreement descriptor Java classes", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new AgreementDescriptorException("Failed to build XML binding from Agreement descriptor Java classes", ex);
        }
        return doc.getDocumentElement();
    }

    public static Element buildXmlEndpointDescriptor(Endpoint epr) throws AgreementDescriptorException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            AgreementDescriptorBuilder.getMarshaller().marshal((Object)epr, (Node)doc);
        }
        catch (JAXBException ex) {
            throw new AgreementDescriptorException("Failed to build XML binding from Agreement descriptor Java classes", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new AgreementDescriptorException("Failed to build XML binding from Agreement descriptor Java classes", ex);
        }
        return doc.getDocumentElement();
    }

    public static JAXBElement<EndpointReferenceType> buildXmlJaxbEndpointDescriptor(Endpoint epr) throws AgreementDescriptorException {
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(epr.marshall2String().getBytes());
            JAXBElement endpointReferenceBinding = AgreementDescriptorBuilder.getUnMarshaller().unmarshal((Source)new StreamSource(input), EndpointReferenceType.class);
            return endpointReferenceBinding;
        }
        catch (JAXBException e) {
            throw new AgreementDescriptorException("Failed to build Java bindings from EndpointReference descriptor XML document", e);
        }
        catch (AgreementDescriptorException e) {
            throw new AgreementDescriptorException("Failed to build Java bindings from EndpointReference descriptor XML document", e);
        }
        catch (AddressingException e) {
            throw new AgreementDescriptorException("Failed to build Java bindings from EndpointReference descriptor XML document", e);
        }
    }

    public static String buildXmlStringAgreementdescriptor(Agreement agreementDescriptor) throws AgreementDescriptorException {
        try {
            StringWriter stringWriter = new StringWriter();
            AgreementDescriptorBuilder.getMarshaller().marshal((Object)agreementDescriptor, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new AgreementDescriptorException("Failed to build XML binding from Agreement descriptor Java classes", e);
        }
    }

    private static Unmarshaller getUnMarshaller() throws AgreementDescriptorException {
        if (unmarshallerCreationEx != null) {
            throw unmarshallerCreationEx;
        }
        return unmarshaller;
    }

    public static Marshaller getMarshaller() throws AgreementDescriptorException {
        if (marshallerCreationEx != null) {
            throw marshallerCreationEx;
        }
        return marshaller;
    }

    public static Unmarshaller getUnmarshaller() throws AgreementDescriptorException {
        if (unmarshallerCreationEx != null) {
            throw unmarshallerCreationEx;
        }
        return unmarshaller;
    }

    public static void setMarshaller(Marshaller marshaller) {
        AgreementDescriptorBuilder.marshaller = marshaller;
    }

    public static JAXBContext getJaxbContext() {
        return jaxbContext;
    }

    public static void setJaxbContext(JAXBContext jaxbContext) {
        AgreementDescriptorBuilder.jaxbContext = jaxbContext;
    }

    static {
        unmarshaller = null;
        unmarshallerCreationEx = null;
        marshaller = null;
        marshallerCreationEx = null;
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            URL schemaUrl = AgreementDescriptorBuilder.class.getResource("/agreement.xsd");
            URL schemaUrlExt = AgreementDescriptorBuilder.class.getResource("/agreementExtensions.xsd");
            URL schemaUrlEndpoint = Endpoint.class.getResource("/addressing.xsd");
            URL schemaUrlEndpointPolicy = Endpoint.class.getResource("/policy.xsd");
            Schema schema = factory.newSchema(new StreamSource[]{new StreamSource(schemaUrl.openStream()), new StreamSource(schemaUrlExt.openStream()), new StreamSource(schemaUrlEndpoint.openStream()), new StreamSource(schemaUrlEndpointPolicy.openStream())});
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class, org.w3._2005._08.addressing.ObjectFactory.class, sla.ebmwebsourcing.com.agreementextensions.ObjectFactory.class});
                unmarshaller = jaxbContext.createUnmarshaller();
                unmarshaller.setSchema(schema);
            }
            catch (JAXBException e) {
                unmarshallerCreationEx = new AgreementDescriptorException("Failed to create the JAXB unmarshaller", e);
            }
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class, org.w3._2005._08.addressing.ObjectFactory.class, sla.ebmwebsourcing.com.agreementextensions.ObjectFactory.class});
                marshaller = jaxbContext.createMarshaller();
                marshaller.setSchema(schema);
            }
            catch (JAXBException e) {
                marshallerCreationEx = new AgreementDescriptorException("Failed to create the JAXB marshaller", e);
            }
        }
        catch (IOException e) {
            AgreementDescriptorException schemaCreationEx = new AgreementDescriptorException("Failed to get resource 'agreement.xsd'from the current class-path", e);
            unmarshallerCreationEx = new AgreementDescriptorException("Failed to create the JAXB unmarshaller", schemaCreationEx);
            marshallerCreationEx = new AgreementDescriptorException("Failed to create the JAXB marshaller", schemaCreationEx);
        }
        catch (SAXException e) {
            AgreementDescriptorException schemaCreationEx = new AgreementDescriptorException("Failed to parse resource 'agreement.xsd'", e);
            unmarshallerCreationEx = new AgreementDescriptorException("Failed to create the JAXB unmarshaller", schemaCreationEx);
            marshallerCreationEx = new AgreementDescriptorException("Failed to create the JAXB marshaller", schemaCreationEx);
        }
    }
}

