/**
 * Web commons : persistence.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * LongIdBaseObject.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.webcommons.persistence.bo;

import java.math.BigDecimal;
import java.math.BigInteger;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * @author ofabre - ebmwebsourcing
 * 
 */
@MappedSuperclass
public abstract class LongIdBaseObject extends BaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = -850389492602515013L;

    private long id;

    @Override
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Long getId() {
        return id;
    }

    public void setId(final Object o) {
        if (o instanceof BigInteger) {
            String tmp = String.valueOf(o);
            long id = Long.valueOf(tmp);
            this.id = id;
        } else {
            long id = (Long) o;
            this.id = id;
        }
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("id", this.id)
                .toString();
    }

    public void setID(final Object o) {
        if (o instanceof BigDecimal) {
            String tmp = String.valueOf(o);
            long id = Long.valueOf(tmp);
            this.id = id;
        }
        if (o instanceof BigInteger) {
            String tmp = String.valueOf(o);
            long id = Long.valueOf(tmp);
            this.id = id;
        } 
    }

}
