/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webcommons.persistence.dao;

import com.ebmwebsourcing.webcommons.persistence.bo.BaseObject;
import com.ebmwebsourcing.webcommons.persistence.dao.DAOLayerException;
import com.ebmwebsourcing.webcommons.persistence.dao.GenericORMDAO;
import com.ebmwebsourcing.webcommons.persistence.dao.util.HibernateQueryHelper;
import com.ebmwebsourcing.webcommons.persistence.dao.util.RequestOptions;
import com.trg.search.IMutableSearch;
import com.trg.search.ISearch;
import com.trg.search.Search;
import com.trg.search.SearchResult;
import com.trg.search.hibernate.HibernateSearchProcessor;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class GenericHibernateDAOImpl<T extends BaseObject, PK extends Serializable>
extends HibernateDaoSupport
implements GenericORMDAO<T, PK> {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final Analyzer defaultAnalyser = new StandardAnalyzer(Version.LUCENE_29);
    private LocalSessionFactoryBean localSessionFactoryBean;
    public Class<T> type;

    public LocalSessionFactoryBean getLocalSessionFactoryBean() {
        return this.localSessionFactoryBean;
    }

    public void setLocalSessionFactoryBean(LocalSessionFactoryBean localSessionFactoryBean) {
        this.localSessionFactoryBean = localSessionFactoryBean;
    }

    public GenericHibernateDAOImpl(SessionFactory factory) {
        this.setSessionFactory(factory);
        this.setType();
    }

    public void setType() {
        Type genericType;
        Type thisType = this.getClass().getGenericInterfaces()[0];
        if (thisType instanceof ParameterizedType) {
            genericType = ((ParameterizedType)thisType).getActualTypeArguments()[0];
        } else if (thisType instanceof Class) {
            genericType = ((ParameterizedType)((Class)thisType).getGenericInterfaces()[0]).getActualTypeArguments()[0];
        } else {
            throw new IllegalArgumentException("Problem handling type construction for " + this.getClass());
        }
        if (genericType.getClass().getName().contains("java.lang.Class")) {
            this.logger.debug((Object)("###### Create dao for entity :" + ((Class)genericType).getCanonicalName()));
            this.type = (Class)genericType;
        }
    }

    @Override
    public List<T> getAll(RequestOptions requestOptions) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        ISearch search = HibernateQueryHelper.createSearchContext(this.type, null, null, requestOptions, null);
        return searchProcessor.search(this.getSession(), search);
    }

    @Override
    public List<T> getAll() {
        return super.getHibernateTemplate().loadAll(this.type);
    }

    @Override
    public List<T> getAll(List<PK> ids) {
        return this.getAll(ids, null);
    }

    @Override
    public List<T> getAll(List<PK> ids, RequestOptions requestOptions) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        Search search = (Search)HibernateQueryHelper.createSearchContext(this.type, null, null, requestOptions, null);
        search.addFilterIn("id", ids);
        return searchProcessor.search(this.getSession(), (ISearch)search);
    }

    @Override
    public List<T> getAllDistinct() {
        LinkedHashSet<T> result = new LinkedHashSet<T>(this.getAll());
        return new ArrayList<T>(result);
    }

    @Override
    public T get(PK id) {
        BaseObject entity = (BaseObject)super.getHibernateTemplate().get(this.type, id);
        return (T)entity;
    }

    @Override
    public boolean exists(PK id) {
        BaseObject entity = (BaseObject)super.getHibernateTemplate().get(this.type, id);
        return entity != null;
    }

    @Override
    public T save(T object) {
        super.getHibernateTemplate().saveOrUpdate(object);
        return object;
    }

    @Override
    public void remove(PK id) {
        Object object = this.get((Serializable)id);
        if (object != null) {
            super.getHibernateTemplate().delete(object);
        }
    }

    @Override
    public void remove(T object) {
        if (object != null) {
            super.getHibernateTemplate().delete(object);
        }
    }

    @Override
    public void removeAll(List<T> objects) {
        if (objects != null) {
            super.getHibernateTemplate().deleteAll(objects);
        }
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        String[] params = new String[queryParams.size()];
        Object[] values = new Object[queryParams.size()];
        int index = 0;
        Iterator<String> i = queryParams.keySet().iterator();
        while (i.hasNext()) {
            String key;
            params[index] = key = i.next();
            values[index++] = queryParams.get(key);
        }
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam(queryName, params, values);
    }

    @Override
    public Class<T> getManipulatedType() {
        return this.type;
    }

    @Override
    public List<T> search(IMutableSearch search) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        search.setSearchClass(this.type);
        return searchProcessor.search(this.getSession(), (ISearch)search);
    }

    @Override
    public int count(IMutableSearch search) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        search.setSearchClass(this.type);
        return searchProcessor.count(this.getSession(), (ISearch)search);
    }

    @Override
    public SearchResult<T> searchAndCount(IMutableSearch search) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        search.setSearchClass(this.type);
        return searchProcessor.searchAndCount(this.getSession(), (ISearch)search);
    }

    @Override
    public T searchUnique(IMutableSearch search) throws NonUniqueResultException {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        search.setSearchClass(this.type);
        return (T)((BaseObject)searchProcessor.searchUnique(this.getSession(), (ISearch)search));
    }

    @Override
    public List<T> searchEquals(String[] criteria, String[] properties, RequestOptions requestOptions) {
        return this.search(criteria, properties, requestOptions, "=");
    }

    @Override
    public List<T> searchLike(String[] criteria, String[] properties, RequestOptions requestOptions) {
        return this.search(criteria, properties, requestOptions, "like");
    }

    private List<T> search(String[] criteria, String[] properties, RequestOptions requestOptions, String predicate) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        ISearch search = HibernateQueryHelper.createSearchContext(this.type, criteria, properties, requestOptions, predicate);
        return searchProcessor.search(this.getSession(), search);
    }

    @Override
    public List<T> searchLucene(String[] criteria, String[] searchedProperties) throws DAOLayerException {
        if (this.type == null) {
            this.setType();
        }
        return this.searchLucene(criteria, searchedProperties, null);
    }

    @Override
    public List<T> searchLucene(String[] criteria, String[] searchedProperties, RequestOptions requestOptions) throws DAOLayerException {
        Query luceneQuery;
        if (criteria.length == 0 || searchedProperties.length == 0) {
            throw new DAOLayerException("Search criterii and properties can't be empty.");
        }
        FullTextSession fullTextSession = this.getFullTextSession();
        MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_29, searchedProperties, this.defaultAnalyser);
        String critString = this.createCritString(criteria);
        try {
            parser.setDefaultOperator(QueryParser.OR_OPERATOR);
            luceneQuery = parser.parse(critString);
        }
        catch (ParseException e) {
            throw new DAOLayerException("Can't parse lucene query", e);
        }
        this.logger.debug((Object)("Lucene query is: " + luceneQuery.toString()));
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{this.getManipulatedType()});
        List<T> result = null;
        if (requestOptions != null) {
            if (!requestOptions.hasSortOption()) {
                HibernateQueryHelper.applyRequestOptions(fullTextQuery, requestOptions, this.getManipulatedType(), this.getSession());
                result = fullTextQuery.list();
            } else {
                result = fullTextQuery.list();
                List<PK> ids = this.createIdList(result);
                result = this.getAll(ids, requestOptions);
            }
        } else {
            result = fullTextQuery.list();
        }
        return result;
    }

    private List<PK> createIdList(List<T> result) {
        ArrayList<Serializable> ids = new ArrayList<Serializable>();
        for (BaseObject t : result) {
            ids.add((Serializable)t.getId());
        }
        return ids;
    }

    private String createCritString(String[] criteria) {
        String result = "";
        for (String string : criteria) {
            result = result + " AND " + string;
        }
        return "(" + result.substring(4) + ")";
    }

    @Override
    public FullTextSession getFullTextSession() {
        return org.hibernate.search.Search.getFullTextSession((Session)this.getSession());
    }
}

