/**
 * Web commons : user service.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * RoleManager.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.webcommons.user.api.service;

/**
 * A manager of Role . Provides methods to retrieve role. 
 * Method arguments must be non null, unless the
 * contrary is explicitly specified.
 * 
 * @author strino - eBM WebSourcing
 * 
 */

import java.io.IOException;

import org.springframework.transaction.annotation.Transactional;

@Transactional
public interface RoleManager {

    /**
     * Add all roles in Registry, if not exist
     * 
     */
    public void init() throws IOException;

    /**
     * Add a new Role in registry. The Role name must be specified.
     * 
     * @param roleName
     *            {@link String}
     */
    public void createRole(String roleName);

    /**
     * Return the list of all roles in database.
     * 
     * @return the list of all roles in database. Can't be null, could be empty
     */
    String[] getAllRoles();

}
