/**
 * Web commons : user service.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * UserTO.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.webcommons.user.api.to;

import java.util.List;

/**
 * 
 * This type gives the description of an user.
 * 
 * @author strino - eBM WebSourcing
 */

public class UserTO {
    // ==========================================================
    // === Attributes
    // ==========================================================
    private String name;

    private String id;

    private List<RoleGroupTO> listRoleGroup;

    private String password;

    private List<RoleTO> listRoles;

    private BasicProfileTO profile;

    // ==========================================================
    // === Constructor
    // ==========================================================
    public UserTO() {

    }

    /*
     * Getters and setters
     */

    /**
     * @return the id
     */
    public String getId() {
        return id;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the listRoles
     */
    public List<RoleGroupTO> getListRoleGroup() {

        return listRoleGroup;
    }

    /**
     * @param listRoles
     *            the listRoles to set
     */
    public void setListRoleGroup(List<RoleGroupTO> listRoleGroup) {
        this.listRoleGroup = listRoleGroup;
    }

    /**
     * @return the password
     */
    public String getPassword() {
        return password;
    }

    /**
     * @param password
     *            the password to set
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * @return the listRoles
     */
    public List<RoleTO> getListRoles() {
        return listRoles;
    }

    /**
     * @param listRoles
     *            the listRoles to set
     */
    public void setListRoles(List<RoleTO> listRoles) {
        this.listRoles = listRoles;
    }

    /**
     * @return the profile
     */
    public BasicProfileTO getProfile() {
        return profile;
    }

    /**
     * @param profile
     *            the profile to set
     */
    public void setProfile(BasicProfileTO profile) {
        this.profile = profile;
    }

}
