/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * MyUserDetailsService.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.webcommons.user.auth;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

import com.ebmwebsourcing.webcommons.user.api.service.UserException;
import com.ebmwebsourcing.webcommons.user.api.service.UserManager;
import com.ebmwebsourcing.webcommons.user.api.to.RoleTO;
import com.ebmwebsourcing.webcommons.user.api.to.UserTO;

/**
 * 
 * @author strino - eBM Websourcing
 * 
 */

public class MyUserDetailsService implements UserDetailsService {

    private final Logger logger = Logger.getLogger(this.getClass());

    private UserManager userManager;

    public UserDetails loadUserByUsername(String login) {

        try {
            // retrieve user by its login in database
            UserTO user = userManager.getUserByLogin(login);

            if (null == user) {
                logger.error("User with login : " + login + " not found in database.");
                throw new UsernameNotFoundException("user not found in database");
            }

            List<RoleTO> roles = user.getListRoles();

            GrantedAuthority[] arrayAuths = new GrantedAuthority[roles.size() + 1];
            int i = 0;
            arrayAuths[i++] = new GrantedAuthorityImpl("ROLE_AUTH");

            for (RoleTO role : roles) {
                arrayAuths[i++] = new GrantedAuthorityImpl("ROLE_" + role.getName());
            }

            org.springframework.security.core.userdetails.User springUser = new org.springframework.security.core.userdetails.User(
                    login, user.getPassword(), true, true, true, true, arrayAuths);

            return springUser;
        } catch (DataAccessException e) {

            throw new UsernameNotFoundException("Authentification failed for user " + login, e);

        } catch (UserException u) {

            logger.error(u.getMessage(), u);

            throw new UsernameNotFoundException("Authentification failed for user " + login);
        }

    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

}
