/**
 * Web commons : user service.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * BasicProfile.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.webcommons.user.persistence.bo;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

import com.ebmwebsourcing.webcommons.persistence.bo.StringIdBaseObject;

/**
 * @author ofabre
 * 
 */
@Entity(name = "com.ebmwebsourcing.webcommons.user.persistence.bo.BasicProfile")
@Inheritance(strategy = InheritanceType.JOINED)
public class BasicProfile extends StringIdBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = 3932501403928978977L;

    private String email;

    private String firstname;

    private String lastname;

    private String phone;

    private String title;

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstname() {
        return firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof BasicProfile))
            return false;
        BasicProfile castOther = (BasicProfile) other;
        return new EqualsBuilder().append(email, castOther.email).append(firstname,
                castOther.firstname).append(lastname, castOther.lastname).append(phone,
                castOther.phone).append(title, castOther.title).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(email).append(firstname).append(lastname).append(phone)
                .append(title).toHashCode();
    }

}
