/**
 * Web commons : user service.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * RolesAndUsersTransfertObjectAssembler.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.webcommons.user.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ebmwebsourcing.webcommons.user.api.to.RoleGroupTO;
import com.ebmwebsourcing.webcommons.user.api.to.UserTO;
import com.ebmwebsourcing.webcommons.user.persistence.bo.RoleGroup;
import com.ebmwebsourcing.webcommons.user.persistence.bo.User;

/**
 * @author strino - eBM WebSourcing
 * 
 */

@Transactional(readOnly = true)
public interface RolesAndUsersTransfertObjectAssembler {

    public void toRoleGroupBO(RoleGroupTO roleGroupTO, RoleGroup roleGroupBO);

    public List<RoleGroupTO> toAllGroupes(List<RoleGroup> listRoleBO);

    public RoleGroupTO toRoleGroupTO(RoleGroup groupeRoles);

    public void toUserBO(UserTO userTO, User userBO);

    public UserTO toUserTO(User user);

}
