/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webcommons.util;

import com.ebmwebsourcing.webcommons.util.StringHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.util.ResourceUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLUtil {
    private static final String XML_ENCODING_ATTRIBUTE = "encoding";
    private static final String XML_HEADER_END = "?>";
    private static final String XML_HEADER_START = "<?xml";
    private static final String DEFAULT_CHARSET_ENCODING = "UTF-8";
    private static final Logger LOGGER = Logger.getLogger(XMLUtil.class.getName());
    private static final ThreadLocal<DocumentBuilder> documentBuilderThreadLocal = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                return documentBuilder;
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Failed to create DocumentBuilder", e);
            }
        }
    };
    private static final ThreadLocal<Transformer> transformerWithoutXmlDeclarationThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                Properties props = new Properties();
                props.put("omit-xml-declaration", "yes");
                props.put("method", "xml");
                transformer.setOutputProperties(props);
                return transformer;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
        }
    };
    private static final ThreadLocal<Transformer> defaultTransformerThreadLocal = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                Properties props = new Properties();
                props.put("omit-xml-declaration", "no");
                props.put("method", "xml");
                transformer.setOutputProperties(props);
                return transformer;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Failed to create Transformer", e);
            }
        }
    };

    private XMLUtil() {
    }

    public static Node createAttribute(Document document, String att, String value) {
        Attr element = null;
        if (document != null) {
            element = document.createAttribute(att);
            element.setNodeValue(value);
        }
        return element;
    }

    public static Node createNode(Document document, String nodeName, String ... attVal) {
        Element element = null;
        if (document != null && attVal.length % 2 == 0) {
            element = document.createElement(nodeName);
            for (int i = 0; i < attVal.length; i += 2) {
                element.getAttributes().setNamedItem(XMLUtil.createAttribute(document, attVal[i], attVal[i + 1]));
            }
        }
        return element;
    }

    @Deprecated
    public static Node findChild(Node node, String nodeName, boolean recursive) {
        node.normalize();
        Node result = null;
        NodeList nl = node.getChildNodes();
        if (node != null && nodeName != null && (result = XMLUtil.lookupNodeInNodeList(nodeName, nl)) == null && recursive) {
            for (int i = 0; i < nl.getLength() && result == null; ++i) {
                result = XMLUtil.findChild(nl.item(i), nodeName, true);
            }
        }
        return result;
    }

    @Deprecated
    private static Node lookupNodeInNodeList(String nodeName, NodeList nl) {
        Node result = null;
        for (int i = 0; i < nl.getLength() && result == null; ++i) {
            if (!nodeName.equals(nl.item(i).getNodeName())) continue;
            result = nl.item(i);
        }
        return result;
    }

    private static Node lookupNodeInNodeList(String nodeName, String namespace, NodeList nl) {
        Node result = null;
        for (int i = 0; i < nl.getLength() && result == null; ++i) {
            if (namespace != null && nl.item(i).getNamespaceURI() != null && nl.item(i).getNamespaceURI().equals(namespace) && nodeName.equals(nl.item(i).getLocalName())) {
                result = nl.item(i);
                continue;
            }
            if (!nodeName.equals(nl.item(i).getNodeName())) continue;
            result = nl.item(i);
        }
        return result;
    }

    public static Node findChild(Node node, String nodeName, String namespaceURI, boolean recursive) {
        node.normalize();
        Node result = null;
        NodeList nl = node.getChildNodes();
        if (node != null && nodeName != null && (result = XMLUtil.lookupNodeInNodeList(nodeName, namespaceURI, nl)) == null && recursive) {
            for (int i = 0; i < nl.getLength() && result == null; ++i) {
                result = XMLUtil.findChild(nl.item(i), nodeName, namespaceURI, true);
            }
        }
        return result;
    }

    public static String parseToString(Node node) throws TransformerException {
        String result = null;
        if (node != null) {
            node.normalize();
            StringWriter stringWriter = new StringWriter();
            defaultTransformerThreadLocal.get().transform(new DOMSource(node), new StreamResult(stringWriter));
            StringBuffer buffer = stringWriter.getBuffer();
            result = buffer.toString();
        }
        return result;
    }

    public static String getAttributeValue(Node n, String attName) {
        NamedNodeMap atts;
        Node att;
        String ret = null;
        if (n != null && (att = (atts = n.getAttributes()).getNamedItem(attName)) != null) {
            ret = att.getNodeValue();
        }
        return ret;
    }

    public static String getRequiredAttributeValue(Node n, String attName) {
        String ret = null;
        if (n != null && !StringHelper.isNullOrEmpty(attName)) {
            NamedNodeMap atts = n.getAttributes();
            Node att = atts.getNamedItem(attName);
            if (att == null) {
                throw new NullPointerException("Required attribute '" + attName + "' not found in the node.");
            }
            if (att != null) {
                ret = att.getNodeValue();
            }
        }
        return ret;
    }

    public static Node getFirstChild(Node node) {
        Node result;
        for (result = node.getFirstChild(); result != null && (result.getNodeType() == 3 || result.getNodeType() == 4); result = result.getNextSibling()) {
        }
        return result;
    }

    public static Node getNextSibling(Node node) {
        Node result = null;
        if (node != null) {
            for (result = node.getNextSibling(); result != null && (result.getNodeType() == 3 || result.getNodeType() == 4); result = result.getNextSibling()) {
            }
        }
        return result;
    }

    public static String getTextContent(Node node) {
        String result = null;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String cdataContent;
            Node currentNode = list.item(i);
            if (currentNode.getNodeType() != 3 && currentNode.getNodeType() != 4) continue;
            result = currentNode.getNodeValue();
            Node nextSiblingNode = currentNode.getNextSibling();
            if (nextSiblingNode != null && nextSiblingNode.getNodeType() == 4 && (cdataContent = nextSiblingNode.getNodeValue()) != null) {
                result = result + cdataContent;
            }
            result = result.replace('\t', ' ').replace('\n', ' ').trim();
            break;
        }
        return result;
    }

    public static String createStringFromDOMDocument(Node document) throws TransformerException {
        return XMLUtil.createStringFromDOMNode(document, false);
    }

    public static String createStringFromDOMNode(Node node) throws TransformerException {
        return XMLUtil.createStringFromDOMNode(node, true);
    }

    public static String createStringFromDOMNodeList(NodeList list) throws TransformerException {
        StringBuffer sb = new StringBuffer("");
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                sb.append(XMLUtil.createStringFromDOMNode(list.item(i)));
            }
        }
        return sb.toString();
    }

    public static String createStringFromDOMNode(Node node, boolean omitDeclaration) throws TransformerException {
        node.normalize();
        DOMSource source = new DOMSource(node);
        StringWriter out = new StringWriter();
        StreamResult resultStream = new StreamResult(out);
        if (omitDeclaration) {
            transformerWithoutXmlDeclarationThreadLocal.get().transform(source, resultStream);
        } else {
            defaultTransformerThreadLocal.get().transform(source, resultStream);
        }
        return out.toString();
    }

    public static Document createDocumentFromString(String xml) {
        Document doc = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
            InputSource inputSource = new InputSource(in);
            doc = documentBuilderThreadLocal.get().parse(inputSource);
            doc.normalize();
        }
        catch (SAXException e) {
            LOGGER.log(Level.SEVERE, "Bad XML fragment can't be transformed to a DOM tree.", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Unexpected Error", e);
        }
        return doc;
    }

    public static List<String> getTextContents(NodeList list) {
        ArrayList<String> result = null;
        if (list != null) {
            result = new ArrayList<String>();
            for (int i = 0; i < list.getLength(); ++i) {
                Node pathElement = list.item(i);
                if (pathElement.getNodeType() == 3) continue;
                result.add(XMLUtil.getTextContent(pathElement));
            }
        }
        return result;
    }

    public static QName extractXmlAttributeQName(Node node, String attrName) {
        String attr = XMLUtil.getAttributeValue(node, attrName);
        QName qName = null;
        if (attr != null) {
            if (attr.indexOf(58) > -1 && attr.charAt(0) != '{') {
                String ns = attr.substring(0, attr.indexOf(58));
                String namespace = node.lookupNamespaceURI(ns);
                qName = new QName(namespace, attr.substring(attr.indexOf(58) + 1), ns);
            } else {
                qName = QName.valueOf(attr);
            }
        }
        return qName;
    }

    public static String extractXmlEncoding(String msg) {
        String xmlEncoding = DEFAULT_CHARSET_ENCODING;
        if (msg.indexOf(XML_HEADER_START) > -1) {
            String xmlHeader = msg.substring(msg.indexOf(XML_HEADER_START), msg.indexOf(XML_HEADER_END) + 2);
            if ((xmlHeader = StringHelper.replace(xmlHeader, '\"', '\'')).indexOf(XML_ENCODING_ATTRIBUTE) > -1) {
                System.out.println(xmlHeader);
                xmlEncoding = xmlHeader.substring(xmlHeader.indexOf(XML_ENCODING_ATTRIBUTE) + XML_ENCODING_ATTRIBUTE.length() + 2);
                xmlEncoding = xmlEncoding.substring(0, xmlEncoding.indexOf("'"));
            }
        }
        return xmlEncoding;
    }

    public static QName extractRequiredXmlAttributeQName(Node node, String attrName) {
        String attr = XMLUtil.getRequiredAttributeValue(node, attrName);
        QName qName = null;
        if (attr.indexOf(58) > -1 && attr.charAt(0) != '{') {
            String ns = attr.substring(0, attr.indexOf(58));
            String namespace = node.lookupNamespaceURI(ns);
            qName = new QName(namespace, attr.substring(attr.indexOf(58) + 1), ns);
        } else {
            qName = QName.valueOf(attr);
        }
        return qName;
    }

    public static List<Node> getNodeChildren(Node node) {
        ArrayList<Node> children = new ArrayList<Node>();
        if (node != null) {
            NodeList childrenList = node.getChildNodes();
            for (int i = 0; i < childrenList.getLength(); ++i) {
                Node child = childrenList.item(i);
                if (child.getNodeType() != 1) continue;
                children.add(child);
            }
        }
        return children;
    }

    public static Node getNode(Document document, String elementName) {
        NodeList resList;
        Node result = null;
        if (document != null && elementName != null && (resList = document.getElementsByTagName(elementName)) != null && resList.getLength() > 0) {
            return resList.item(0);
        }
        return result;
    }

    public static Node getNodeWithAttribute(Document document, String elementName, String attributeName, String attributeValue) {
        Element result = null;
        if (document != null && elementName != null && attributeName != null && attributeValue != null) {
            NodeList resList = document.getElementsByTagName(elementName);
            for (int i = 0; i < resList.getLength() && result == null; ++i) {
                Element curNode = (Element)resList.item(i);
                if (!attributeValue.equals(curNode.getAttribute(attributeName))) continue;
                result = curNode;
            }
        }
        return result;
    }

    public static void writeDocument(Document document, OutputStream outputStream) throws Exception {
        if (document == null || outputStream == null) {
            throw new Exception("Can not write document to output stream");
        }
        defaultTransformerThreadLocal.get().transform(new DOMSource(document), new StreamResult(outputStream));
    }

    public static Document loadDocument(InputStream inputStream) throws IOException, SAXException {
        return documentBuilderThreadLocal.get().parse(inputStream);
    }

    public static InputSource createWsdlSource(Document wsdlDoc) throws Exception {
        InputSource wsdlSource = null;
        try {
            wsdlSource = new InputSource(new ByteArrayInputStream(XMLUtil.createStringFromDOMDocument(wsdlDoc).getBytes()));
        }
        catch (TransformerException e) {
            throw new Exception("Can't create input source from the given wsdl Document.", e);
        }
        return wsdlSource;
    }

    public static InputSource createWsdlSource(URI wsdlURI) throws Exception {
        InputSource inputSource;
        try {
            InputStream inputStream = ResourceUtils.getURL((String)wsdlURI.toString()).openStream();
            inputSource = new InputSource(inputStream);
        }
        catch (Exception e) {
            throw new Exception("Can't read WSDL file at URL: " + wsdlURI.toString());
        }
        return inputSource;
    }

    public static Document createDocument() {
        return documentBuilderThreadLocal.get().newDocument();
    }

    public static Document createDocument(InputStream is) throws SAXException, IOException {
        return documentBuilderThreadLocal.get().parse(is);
    }

    public static Document createDocument(InputSource is) throws SAXException, IOException {
        return documentBuilderThreadLocal.get().parse(is);
    }

    public static StreamSource toStreamSource(DOMSource domSource) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(os);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(domSource, streamResult);
        os.flush();
        os.close();
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        return new StreamSource(is);
    }

    public static Node searchNode(NodeList list, String nodeName) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node seekedNode;
            Node node = list.item(i);
            if (node.getNodeName().contains(nodeName)) {
                return node;
            }
            NodeList subList = node.getChildNodes();
            if (subList == null || subList.getLength() <= 0 || (seekedNode = XMLUtil.searchNode(subList, nodeName)) == null) continue;
            return seekedNode;
        }
        return null;
    }

    public static List<Node> searchNodes(Document doc, String nodeName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList nodeList = doc.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node childNode = nodeList.item(i);
                if (childNode.getLocalName().equals(nodeName)) {
                    nodes.add(childNode);
                    continue;
                }
                List<Node> childNodes = XMLUtil.searchNodes(childNode, nodeName);
                if (childNodes == null || childNodes.size() <= 0) continue;
                nodes.addAll(childNodes);
            }
        }
        return nodes;
    }

    public static List<Node> searchNodes(Node node, String nodeName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node childNode = nodeList.item(i);
                if (childNode.getLocalName().equals(nodeName)) {
                    nodes.add(childNode);
                    continue;
                }
                List<Node> childNodes = XMLUtil.searchNodes(childNode, nodeName);
                if (childNodes == null || childNodes.size() <= 0) continue;
                nodes.addAll(childNodes);
            }
        }
        return nodes;
    }
}

