/**
 * easySchema - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.ebmwebsourcing.wsstar.addressing.definition.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;

import org.xml.sax.SAXException;

import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class WSAddressingJAXBContext {
	
	private static final List<Class> defaultObjectFactories = new ArrayList<Class>(Arrays.asList(new Class[] {
    		com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.ObjectFactory.class}));


    /**
     * The JAXB context
     */
    private static JAXBContext jaxbContext;

	/**
     * Private object initializations
     */
    public static void createDefaultContext() throws WSAddressingException {
        final SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

        // The EndpointReference schema resource is in the Jar where the class
        // is
        // loaded
        final URL schemaUrl = WSAddressingException.class.getResource("/" + "schema/ws-addr.xsd");

        try {
            factory.newSchema(new StreamSource[] { new StreamSource(schemaUrl.openStream()) });

            WSAddressingJAXBContext.jaxbContext = JAXBContext
                    .newInstance(defaultObjectFactories.toArray(new Class[defaultObjectFactories.size()]));

        } catch (final SAXException e) {
            throw new WSAddressingException(e);
        } catch (final IOException e) {
            throw new WSAddressingException(e);
        } catch (final JAXBException e) {
            throw new WSAddressingException(e);
        }

    }
    
    public static void createContextWithOtherObjectFactories(List<Class> addedObjectFactories) throws WSAddressingException {
        final SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

        // The EndpointReference schema resource is in the Jar where the class
        // is
        // loaded
        final URL schemaUrl = WSAddressingJAXBContext.class.getResource("/" + "schema/ws-addr.xsd");

        List<Class> objectFactories = new ArrayList<Class>();
        objectFactories.addAll(defaultObjectFactories);
        if(addedObjectFactories != null) {
            objectFactories.addAll(addedObjectFactories);
        }
        try {
            factory.newSchema(new StreamSource[] { new StreamSource(schemaUrl.openStream()) });

            WSAddressingJAXBContext.jaxbContext = JAXBContext
                    .newInstance(objectFactories.toArray(new Class[objectFactories.size()]));

        } catch (final SAXException e) {
            throw new WSAddressingException(e);
        } catch (final IOException e) {
            throw new WSAddressingException(e);
        } catch (final JAXBException e) {
            throw new WSAddressingException(e);
        }

    }


    public static JAXBContext getJaxbContext() {
        return WSAddressingJAXBContext.jaxbContext;
    }
}
