/**
 * easySchema - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.ebmwebsourcing.wsstar.addressing.definition.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;

import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.util.EasyXMLFilter;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingReader;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSAddressingReaderImpl implements WSAddressingReader {

	private static Logger log = Logger.getLogger(WSAddressingReaderImpl.class.getName());

	private Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();


	public WSAddressingReaderImpl() throws WSAddressingException {
		try {
			WSAddressingJAXBContext.createDefaultContext();
		} catch (final WSAddressingException e) {
			throw new WSAddressingException(e);
		}
	}

	public WSAddressingReaderImpl(final List<Class> addedObjectFactories)
	throws WSAddressingException {
		try {
			WSAddressingJAXBContext.createContextWithOtherObjectFactories(addedObjectFactories);
		} catch (final WSAddressingException e) {
			throw new WSAddressingException(e);
		}
	}

	private static com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType convertStream2EndpointReferenceType(
			final Source stream) throws WSAddressingException {

		try {
			// TODO : Check if it is a Thread safe method
			final JAXBElement<com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType> schemaBinding = WSAddressingReaderImpl
			.getJaxbContext().createUnmarshaller().unmarshal(stream,
					com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType.class);

			return schemaBinding.getValue();

		} catch (final JAXBException e) {
			throw new WSAddressingException(
					"Failed to build Java bindings from SchemaImpl descriptor XML document", e);
		}
	}


	/**
	 * @return the jaxbContext
	 */
	public static JAXBContext getJaxbContext() {
		return WSAddressingJAXBContext.getJaxbContext();
	}

	public EndpointReferenceType readEndpointReferenceType(final URI uri) throws WSAddressingException {
		EndpointReferenceType desc = null;
		try {
			InputStream input = null;
			final File f = new File(uri.getPath());
			if (f.exists()) {
				input = new FileInputStream(f);
			} else {
				input = uri.toURL().openStream();
			}
			desc = this.readEndpointReferenceType(uri, new InputSource(input));
		} catch (final MalformedURLException e) {
			throw new WSAddressingException("Can not get wsdl at: " + uri, e);
		} catch (final IOException e) {
			throw new WSAddressingException("Can not get wsdl at: " + uri, e);
		} catch (final SchemaException e) {
			throw new WSAddressingException("Can not get wsdl at: " + uri, e);
		} catch (final XmlException e) {
			throw new WSAddressingException("Can not get wsdl at: " + uri, e);
		}
		return desc;
	}

	public EndpointReferenceType readEndpointReferenceType(final Document document) throws WSAddressingException {
		EndpointReferenceType desc = null;
		try {
			URI uri = new URI(".");
			if(document.getDocumentURI() != null) {
				uri = new URI(document.getDocumentURI());
			}
			desc = this.readEndpointReferenceType(uri, SourceHelper.convertDOMSource2InputSource(new DOMSource(
					document)));
		} catch (final URISyntaxException e) {
			throw new WSAddressingException(e);
		} catch (final XmlException e) {
			throw new WSAddressingException(e);
		}

		return desc;
	}

	public EndpointReferenceType readEndpointReferenceType(final URI uri, final InputSource source) throws WSAddressingException {
		EndpointReferenceType desc = null;
		try {
			final Unmarshaller unmarshaller = WSAddressingJAXBContext.getJaxbContext()
			.createUnmarshaller();

			final XMLReader xmlReader = XMLReaderFactory.createXMLReader();
			final EasyXMLFilter filter = new org.ow2.easywsdl.schema.util.EasyXMLFilter(xmlReader);
			final SAXSource saxSource = new SAXSource(filter, source);

			// TODO use SAX validation instead of JAXB validation
			// turn off the JAXB provider's default validation mechanism to
			// avoid duplicate validation
			// SchemaReaderImpl.getUnMarshaller().setValidating( false );

			final JAXBElement<com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType> eprBinding = unmarshaller.unmarshal(
					saxSource, com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType.class);


			desc = new EndpointReferenceTypeImpl(uri, eprBinding.getValue(), this.getFeatures());
		} catch (final XmlException e) {
			throw new WSAddressingException(e);
		} catch (final JAXBException e) {
			throw new WSAddressingException(e);
		} catch (final SAXException e) {
			throw new WSAddressingException(e);
		}

		return desc;
	}

	public void setFeature(final FeatureConstants name, final Object value)
	throws IllegalArgumentException {
		this.features.put(name, value);
		log.fine("set features: name = " + name + " - value = " + value);
	}

	public Object getFeature(final FeatureConstants name) throws IllegalArgumentException {
		return this.features.get(name);
	}

	public Map<FeatureConstants, Object> getFeatures() {
		return this.features;
	}

	public void setFeatures(final Map<FeatureConstants, Object> features) {
		this.features = features;
	}
}
