/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.inout;

import java.net.URI;
import java.util.Map;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.EndpointReferenceType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.MonitoringPropertiesType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.WSAddressing4AgreementReader;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.WSAddressing4AgreementFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingReader;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingReader.FeatureConstants;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.WSAddressingReaderImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSAddressing4AgreementReaderImpl implements WSAddressing4AgreementReader {

	WSAddressingReader reader = null;


	public WSAddressing4AgreementReaderImpl() throws WSAddressingException {
		WSAddressingFactory factory = WSAddressingFactory.newInstance();
		factory.setJAXBObjectFactoryList(WSAddressing4AgreementJAXBContext.getDefaultObjectFactories());
		this.reader = factory.newWSAddressingReader();
	}

	public Object getFeature(final FeatureConstants name) {
		return this.reader.getFeature(name);
	}

	public Map<FeatureConstants, Object> getFeatures() {
		return this.reader.getFeatures();
	}

	public void setFeatures(final Map<FeatureConstants, Object> features) {
		((WSAddressingReaderImpl) this.reader).setFeatures(features);
	}

	public EndpointReferenceType readEndpointReferenceType(final URI wsdlURI) throws WSAddressingException {
		EndpointReferenceType res = null;
		final com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType desc = this.reader.readEndpointReferenceType(wsdlURI);
		res = WSAddressing4AgreementFactory.newInstance().addMonitoringElmt2Description(desc);
		return res;
	}

	public EndpointReferenceType readEndpointReferenceType(final Document wsdlDocument) throws WSAddressingException {
		EndpointReferenceType res = null;
		final com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType desc = this.reader.readEndpointReferenceType(wsdlDocument);
		res = WSAddressing4AgreementFactory.newInstance().addMonitoringElmt2Description(desc);
		return res;
	}

	public EndpointReferenceType readEndpointReferenceType(final URI wsdlURI, final InputSource inputSource) throws WSAddressingException {
		EndpointReferenceType res = null;
		final com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType desc = this.reader.readEndpointReferenceType(wsdlURI, 
				inputSource);
		res = WSAddressing4AgreementFactory.newInstance().addMonitoringElmt2Description(desc);
		return res;
	}

	public void setFeature(final FeatureConstants name, final Object value) throws WSAddressingException {
		this.reader.setFeature(name, value);
	}


	public JAXBElement<MonitoringPropertiesType> convertElement2MonitoringPropertiesType(final Element pltElmt)
	throws WSAddressingException {
		JAXBElement<MonitoringPropertiesType> res = null;
		try {
			res = WSAddressing4AgreementJAXBContext.getJaxbContext().createUnmarshaller().unmarshal(pltElmt, MonitoringPropertiesType.class);
		} catch (final JAXBException e) {
			throw new WSAddressingException( 
					"Failed to build Java bindings from WSDL descriptor XML document", e);
		}
		return res;
	}
	
}
