/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl;

import javax.xml.bind.JAXBElement;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.MonitoringPropertiesType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.decorator.DecoratorReferenceParametersTypeImpl;
import com.ebmwebsourcing.wsstar.addressing.definition.org.semeuse.monitoring.extension.ObjectFactory;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@SuppressWarnings("unchecked")
public class ReferenceParametersTypeImpl extends DecoratorReferenceParametersTypeImpl implements
		ReferenceParametersType {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private ObjectFactory factory = new ObjectFactory();

	private MonitoringPropertiesType monitoringendpoint;

	@SuppressWarnings("unchecked")
	public ReferenceParametersTypeImpl(final AbsItfReferenceParametersType ref) throws WSAddressingException {
		super(ref);

		for (Object item : ((com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType) ((AbstractSchemaElementImpl) ref)
				.getModel()).getAny()) {
			Object obj = item;
			if (obj instanceof JAXBElement) {
				obj = ((JAXBElement) item).getValue();
			}
			if (obj instanceof com.ebmwebsourcing.wsstar.addressing.definition.org.semeuse.monitoring.extension.MonitoringPropertiesType) {
				monitoringendpoint = new MonitoringPropertiesTypeImpl(
						(com.ebmwebsourcing.wsstar.addressing.definition.org.semeuse.monitoring.extension.MonitoringPropertiesType) obj,
						null);
			}
		}
	}

	public MonitoringPropertiesType getMonitoringPropertiesType() {
		return monitoringendpoint;
	}

	public void setMonitoringPropertiesType(MonitoringPropertiesType type) {
		if (this.monitoringendpoint != null) {
			((com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType) ((AbstractSchemaElementImpl) ref)
					.getModel()).getAny().remove(((AbstractSchemaElementImpl) this.monitoringendpoint).getModel());
		}
		this.monitoringendpoint = type;

		((com.ebmwebsourcing.wsstar.jaxb.addressing.ReferenceParametersType) ((AbstractSchemaElementImpl) ref)
				.getModel())
				.getAny()
				.add(
						this.factory
								.createMonitoringProperties((com.ebmwebsourcing.wsstar.addressing.definition.org.semeuse.monitoring.extension.MonitoringPropertiesType) ((AbstractSchemaElementImpl) this.monitoringendpoint)
										.getModel()));
	}

	public MonitoringPropertiesType newMonitoringPropertiesType() {
		return new MonitoringPropertiesTypeImpl(
				new com.ebmwebsourcing.wsstar.addressing.definition.org.semeuse.monitoring.extension.MonitoringPropertiesType(), null);
	}

}
