/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl;

import java.util.Map;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.EndpointReferenceType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.WSAddressing4AgreementReader;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.WSAddressing4AgreementWriter;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.converter.AddressingConverter;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.inout.WSAddressing4AgreementReaderImpl;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.inout.WSAddressing4AgreementWriterImpl;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingReader.FeatureConstants;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfEndpointReferenceType;


/**
 * This class is a concrete implementation of the abstract class WSDLFactory.
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSAddressing4AgreementFactoryImpl extends WSAddressing4AgreementFactory {

	@SuppressWarnings("unchecked")
	@Override
	public EndpointReferenceType addMonitoringElmt2Description(final AbsItfEndpointReferenceType epr) throws WSAddressingException {
		EndpointReferenceType newEpr = null;
		newEpr = AddressingConverter.getIntance().convertEndpointReferenceType(epr);
		return newEpr;
	}

	@Override
	public WSAddressing4AgreementReader newWSAddressing4AgreementReader() throws WSAddressingException {
		return new WSAddressing4AgreementReaderImpl();
	}

	@Override
	public WSAddressing4AgreementReader newWSAddressing4AgreementReader(final Map<FeatureConstants, Object> features)
	throws WSAddressingException {
		final WSAddressing4AgreementReader reader = new WSAddressing4AgreementReaderImpl();
		((WSAddressing4AgreementReaderImpl) reader).setFeatures(features);
		return reader;
	}

	@Override
	public WSAddressing4AgreementWriter newWSAddressing4AgreementWriter() throws WSAddressingException {
		return new WSAddressing4AgreementWriterImpl();
	}

	@Override
	public EndpointReferenceType newEndpointReferenceType()
			throws WSAddressingException {
		return this.addMonitoringElmt2Description((AbsItfEndpointReferenceType)new com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl(new com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType(), null));
	}

}
