package com.ebmwebsourcing.agreement.definition.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementContextType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.GuaranteeTermType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ObjectFactory;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ServiceDescriptionTermType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ServicePropertiesType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ServiceReferenceType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.TermCompositorType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.TermTreeType;

import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.Context;
import com.ebmwebsourcing.agreement.definition.api.GuaranteeTerms;
import com.ebmwebsourcing.agreement.definition.api.ServiceDescription;
import com.ebmwebsourcing.agreement.definition.api.ServiceProperties;
import com.ebmwebsourcing.agreement.definition.api.ServiceReference;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementReader.FeatureConstants;

public abstract class AgreementTypeImpl<A extends com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementType> extends AbstractSchemaElementImpl<A> implements Agreement {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(AgreementTypeImpl.class.getName());


	/**
	 * the baseUri
	 */
	protected URI baseURI;

	private QName tagName = new QName(Constants.WSAGREEMENT_NAMESPACE, Constants.AGREEMENT_ROOT_TAG);

	private Context context;

	private ServiceDescription serviceDescription;

	private ServiceReference serviceReference;

	private ServiceProperties serviceProperties;

	private List<GuaranteeTerms> guaranteeTerms = new ArrayList<GuaranteeTerms>();

	private ObjectFactory factory = new ObjectFactory();

	/**
	 * Features
	 */
	protected Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();

	public AgreementTypeImpl(final URI baseURI,
			final A model,
			final Map<FeatureConstants, Object> features)
	throws WSAgreementException {
		super(model, null);
		this.baseURI = baseURI;
		this.features = features;

		if(this.model.getContext() != null) {
			this.context = new ContextImpl(this.model.getContext(), this);
		}

		if(this.model.getTerms() != null) {
			for (JAXBElement<?> item : this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll()) {
				if(item.getValue() instanceof ServiceDescriptionTermType){
					this.serviceDescription = new ServiceDescriptionImpl((ServiceDescriptionTermType) item.getValue(), this);
				}
				else if(item.getValue() instanceof ServiceReferenceType) {
					this.serviceReference = new ServiceReferenceImpl((ServiceReferenceType) item.getValue(), this);
				}
				else if(item.getValue() instanceof ServicePropertiesType) {
					this.serviceProperties = new ServicePropertiesImpl((ServicePropertiesType) item.getValue(), this);
				}
				else if(item.getValue() instanceof GuaranteeTermType) {
					this.guaranteeTerms.add(new GuaranteeTermsImpl((GuaranteeTermType) item.getValue(), this));
				}
			}	
		}
	}

	public AgreementTypeImpl(
			final A model,
			final AbstractSchemaElementImpl parent)
	throws WSAgreementException {
		super(model, parent);

		if(this.model.getContext() != null) {
			this.context = new ContextImpl(this.model.getContext(), this);
		}

		if(this.model.getTerms() != null) {
			for (JAXBElement<?> item : this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll()) {
				if(item.getValue() instanceof ServiceDescriptionTermType){
					this.serviceDescription = new ServiceDescriptionImpl((ServiceDescriptionTermType) item.getValue(), this);
				}
				else if(item.getValue() instanceof ServiceReferenceType) {
					this.serviceReference = new ServiceReferenceImpl((ServiceReferenceType) item.getValue(), this);
				}
				else if(item.getValue() instanceof ServicePropertiesType) {
					this.serviceProperties = new ServicePropertiesImpl((ServicePropertiesType) item.getValue(), this);
				}
				else if(item.getValue() instanceof GuaranteeTermType) {
					this.guaranteeTerms.add(new GuaranteeTermsImpl((GuaranteeTermType) item.getValue(), this));
				}
			}	
		}
	}

	public QName getTagQName() {
		return this.tagName;
	}

	public void setTagQName(QName name) {
		this.tagName = name;
	}

	/**
	 * methods for baseURI
	 */
	public URI getDocumentBaseURI() {
		URI res = null;
		try {
			if ((this.baseURI != null)&&(this.baseURI.getPath() != null)&&(this.baseURI.getPath().lastIndexOf("/") != -1)) {
				res = new URI(this.baseURI.getPath().substring(0,
						this.baseURI.getPath().lastIndexOf("/") + 1));
			} else {
				res = this.baseURI;
			}
		} catch (final URISyntaxException e) {
			log.warning("BaseURI is null : " + this.baseURI);
		}
		return res;
	}

	public void setDocumentBaseURI(final URI documentBaseURI) {
		this.baseURI = documentBaseURI;
	}

	public void addGuarantee(GuaranteeTerms term) {
		if(term != null) {
			// create the new term
			JAXBElement<GuaranteeTermType> item = factory.createTermCompositorTypeGuaranteeTerm((GuaranteeTermType) ((AbstractSchemaElementImpl)term).getModel());
			this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().add(item);
			this.guaranteeTerms.add(term);
		}
	}
	
	public void removeGuarantee(GuaranteeTerms term) {
		if(term != null) {
			for(JAXBElement elmt: this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll()) {
				if(elmt.getValue() instanceof GuaranteeTermType) {
					GuaranteeTermType oldModel = (GuaranteeTermType) elmt.getValue();
					if(oldModel.getName().equals(term.getName())) {
						this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().remove(elmt);
						this.guaranteeTerms.remove(term);
						break;
					}
				}
			}
		}
	}

	public Context getContext() {
		return this.context;
	}

	public List<GuaranteeTerms> getGuaranteeTerms() {
		return this.guaranteeTerms;
	}

	public String getName() {
		return this.model.getName();
	}

	public ServiceDescription getServiceDescription() {
		return this.serviceDescription;
	}

	public ServiceProperties getServiceProperties() {
		return this.serviceProperties;
	}

	public ServiceReference getServiceReference() {
		return this.serviceReference;
	}

	public Context newContext() throws WSAgreementException {
		return new ContextImpl(new AgreementContextType(), this);
	}

	public GuaranteeTerms newGuaranteeTerms() throws WSAgreementException {
		return new GuaranteeTermsImpl(new GuaranteeTermType(), this);
	}

	public ServiceDescription newServiceDescription() throws WSAgreementException {
		return new ServiceDescriptionImpl(new ServiceDescriptionTermType(), this);
	}

	public ServiceProperties newServiceProperties() throws WSAgreementException {
		return new ServicePropertiesImpl(new ServicePropertiesType(), this);
	}

	public ServiceReference newServiceReference() throws WSAgreementException {
		return new ServiceReferenceImpl(new ServiceReferenceType(), this);
	}

	public void setContext(Context context) {
		this.model.setContext((AgreementContextType) ((AbstractSchemaElementImpl)context).getModel());
		this.context = context;
	}

	public void setGuaranteeTerms(List<GuaranteeTerms> terms) {
		for(GuaranteeTerms guarantee: terms) {
			this.addGuarantee(guarantee);
		}
	}

	public void setName(String name) {
		this.model.setName(name);
	}

	public void setServiceDescription(ServiceDescription term) {
		this.serviceDescription = term;

		// create the new term
		JAXBElement<ServiceDescriptionTermType> item = factory.createTermCompositorTypeServiceDescriptionTerm((ServiceDescriptionTermType) ((AbstractSchemaElementImpl)term).getModel());


		// replace old term by new term
		if(this.model.getTerms() != null) {
			Iterator<JAXBElement<?>> it = this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().iterator();
			while(it.hasNext()) {
				JAXBElement<?> itemTemp = it.next();
				if(itemTemp.getValue() instanceof ServiceDescriptionTermType) {
					this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().remove(itemTemp);
					it = this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().iterator();
					break;
				}
			}	
		}

		// add the new term
		if(this.model.getTerms() == null) {
			this.model.setTerms(new TermTreeType());
			this.model.getTerms().setAll(new TermCompositorType());
		}
		this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().add(item);

	}

	public void setServiceProperties(ServiceProperties term) {
		this.serviceProperties = term;

		// create the new term
		JAXBElement<ServicePropertiesType> item = factory.createTermCompositorTypeServiceProperties(((ServicePropertiesType) ((AbstractSchemaElementImpl)term).getModel()));

		// replace old term by new term
		if(this.model.getTerms() != null) {
			Iterator<JAXBElement<?>> it = this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().iterator();
			while(it.hasNext()) {
				JAXBElement<?> itemTemp = it.next();
				if(itemTemp.getValue() instanceof ServicePropertiesType) {
					this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().remove(itemTemp);
					it = this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().iterator();
					break;
				}
			}	
		}

		// add the new term
		if(this.model.getTerms() == null) {
			this.model.setTerms(new TermTreeType());
			this.model.getTerms().setAll(new TermCompositorType());
		}
		this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().add(item);

	}

	public void setServiceReference(ServiceReference term) {
		this.serviceReference = term;

		// create the new term
		JAXBElement<ServiceReferenceType> item = factory.createTermCompositorTypeServiceReference(((ServiceReferenceType) ((AbstractSchemaElementImpl)term).getModel()));

		// replace old term by new term
		if(this.model.getTerms() != null) {
			Iterator<JAXBElement<?>> it = this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().iterator();
			while(it.hasNext()) {
				JAXBElement<?> itemTemp = it.next();
				if(itemTemp.getValue() instanceof ServiceReferenceType) {
					this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().remove(itemTemp);
					it = this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().iterator();
					break;
				}
			}	
		}

		// add the new term
		if(this.model.getTerms() == null) {
			this.model.setTerms(new TermTreeType());
			this.model.getTerms().setAll(new TermCompositorType());
		}
		this.model.getTerms().getAll().getExactlyOneOrOneOrMoreOrAll().add(item);
	}


}
