package com.ebmwebsourcing.agreement.definition.impl;

import java.util.logging.Logger;

import javax.xml.bind.JAXBElement;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.GuaranteeTermType;

import com.ebmwebsourcing.agreement.definition.api.Expression;
import com.ebmwebsourcing.agreement.definition.api.GuaranteeTerms;
import com.ebmwebsourcing.agreement.definition.api.QualifyingCondition;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;

import sla.ebmwebsourcing.com.agreementextensions.TExpression;

public class QualifyingConditionImpl  implements QualifyingCondition {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Logger log = Logger.getLogger(QualifyingConditionImpl.class.getName());

	private Expression exp = null;
	
	private GuaranteeTerms guarantee;
	private Object qualifyingCondition;
	
	public QualifyingConditionImpl(Object qualifyingCondition,
			GuaranteeTerms guaranteeTerms) throws WSAgreementException {
		this.qualifyingCondition = qualifyingCondition;
		this.guarantee = guaranteeTerms;
		if(qualifyingCondition instanceof JAXBElement) {
			if(((JAXBElement)qualifyingCondition).getValue() instanceof TExpression) {
				exp = new ExpressionImpl((TExpression)((JAXBElement)qualifyingCondition).getValue(), (AbstractSchemaElementImpl) this.guarantee);
			} 
		} else if(qualifyingCondition instanceof TExpression) {
			exp = new ExpressionImpl((TExpression) qualifyingCondition, (AbstractSchemaElementImpl) this.guarantee);
		}
	}

	public Expression getExpression() {
		return this.exp;
	}

	public void setExpression(Expression exp) {
		if(qualifyingCondition instanceof JAXBElement) {
			if(((JAXBElement)qualifyingCondition).getValue() instanceof TExpression) {
				((JAXBElement)qualifyingCondition).setValue((TExpression)((AbstractSchemaElementImpl)exp).getModel());
			}
		} else if(qualifyingCondition instanceof TExpression) {
			((GuaranteeTermType)((AbstractSchemaElementImpl)this.guarantee).getModel()).setQualifyingCondition((TExpression)((AbstractSchemaElementImpl)exp).getModel());
			this.qualifyingCondition = ((GuaranteeTermType)((AbstractSchemaElementImpl)this.guarantee).getModel()).getQualifyingCondition();
		}
		this.exp = exp;
	}


}
