/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.agreement.definition;

import java.net.URI;
import java.net.URISyntaxException;

import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;

import org.w3c.dom.Document;

import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.AgreementTemplate;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementReader;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementWriter;
import com.ebmwebsourcing.agreement.definition.impl.AgreementImpl;
import com.ebmwebsourcing.agreement.definition.impl.AgreementTemplateImpl;
import com.ebmwebsourcing.agreement.definition.impl.AgreementTypeImpl;
import com.ebmwebsourcing.agreement.definition.impl.WSAgreementReaderImpl;
import com.ebmwebsourcing.agreement.definition.impl.WSAgreementWriterImpl;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingReader;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingWriter;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.WSAddressingReaderImpl;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.WSAddressingWriterImpl;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ObjectFactory;

/**
 * This class is a concrete implementation of the abstract class WSDMFactory.
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 *
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSAgreementFactoryImpl extends WSAgreementFactory {


    private ObjectFactory factory = new ObjectFactory();
    
    /**
     * Create a new instance of a WSDLReaderImpl.
     * @throws WSDMException 
     */
    @Override
    public WSAgreementReader newWSAgreementReader() throws WSAgreementException {
        final WSAgreementReader reader = new WSAgreementReaderImpl();
        return reader;
    }

    /**
     * Create a new instance of a WSDLWriterImpl.
     * @throws WSDMException 
     */
    @Override
    public WSAgreementWriter newWSAgreementWriter() throws WSAgreementException {
        final WSAgreementWriter writer = new WSAgreementWriterImpl();
        return writer;
    }
    
    @Override
    public Agreement newAgreement() throws WSAgreementException {
    	Agreement ag = new AgreementImpl(new com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementType(), null);
    	try {
			ag.setDocumentBaseURI(new URI("."));
		} catch (URISyntaxException e) {
			throw new WSAgreementException(e);
		}
    	return ag;
    }

	@Override
	public AgreementTemplate newAgreementTemplate() throws WSAgreementException {
		AgreementTemplate agT = new AgreementTemplateImpl(new com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementTemplateType(), null);
		try {
			agT.setDocumentBaseURI(new URI("."));
		} catch (URISyntaxException e) {
			throw new WSAgreementException(e);
		}
    	return agT;
	}

    @Override
    public Agreement newAgreementOffer() throws WSAgreementException {
        Agreement agT = new AgreementImpl(factory.createAgreementOffer(new com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementType()).getValue(), null);
        try {
            agT.setDocumentBaseURI(new URI("."));
        } catch (URISyntaxException e) {
            throw new WSAgreementException(e);
        }
        return agT;
    }



}
