package com.ebmwebsourcing.agreement.definition.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.CompensationType;

import com.ebmwebsourcing.agreement.definition.api.BusinessValueList;
import com.ebmwebsourcing.agreement.definition.api.Penalty;
import com.ebmwebsourcing.agreement.definition.api.Reward;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;

public class BusinessValueListImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.BusinessValueListType> implements BusinessValueList {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(BusinessValueListImpl.class.getName());


	private List<Penalty> penalties = new ArrayList<Penalty>();

	private List<Reward> rewards = new ArrayList<Reward>();

	public BusinessValueListImpl(
			final com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.BusinessValueListType model,
			final AbstractSchemaElementImpl parent)
	throws WSAgreementException {
		super(model, parent);

		// get penalties
		for(CompensationType penalty: this.model.getPenalty()) {
			this.penalties.add(new PenaltyImpl(penalty, this));
		}

		// get rewards
		for(CompensationType reward: this.model.getReward()) {
			this.rewards.add(new RewardImpl(reward, this));
		}
	}



	public Integer getImportance() {
		Integer res = null;
		if(this.model.getImportance() != null) {
			res = this.model.getImportance().intValue();
		}
		return res;
	}



	public List<Penalty> getPenalties() {
		return this.penalties;
	}



	public List<Reward> getRewards() {
		return this.rewards;
	}



	public void setImportance(Integer importance) {
		if(importance != null) {
			this.model.setImportance(BigInteger.valueOf(importance));
		} else {
			this.model.setImportance(null);
		}
	}



	public void addPenalty(Penalty penalty) {
		this.model.getPenalty().add((CompensationType) ((AbstractSchemaElementImpl)penalty).getModel());
		this.penalties.add(penalty);
	}



	public void addReward(Reward reward) {
		this.model.getReward().add((CompensationType) ((AbstractSchemaElementImpl)reward).getModel());
		this.rewards.add(reward);
	}
	
	
	public void removePenalty(Penalty penalty) {
		this.model.getPenalty().remove((CompensationType) ((AbstractSchemaElementImpl)penalty).getModel());
		this.penalties.remove(penalty);
	}



	public void removeReward(Reward reward) {
		this.model.getReward().remove((CompensationType) ((AbstractSchemaElementImpl)reward).getModel());
		this.rewards.remove(reward);
	}



	public Penalty newPenalty() throws WSAgreementException {
		return new PenaltyImpl(new CompensationType(), this);
	}



	public Reward newReward() throws WSAgreementException {
		return new RewardImpl(new CompensationType(), this);
	}



}
