package com.ebmwebsourcing.agreement.definition.impl;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Logger;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementRoleType;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.EndpointReferenceType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.WSAddressing4AgreementFactory;
import com.ebmwebsourcing.agreement.definition.api.Context;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfEndpointReferenceType;

public class ContextImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementContextType> implements Context {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ContextImpl.class.getName());



	public ContextImpl(
			final com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.AgreementContextType model,
			final AbstractSchemaElementImpl parent)
	throws WSAgreementException {
		super(model, parent);
	}



	public Date getExpirationTime() {
		Date res = null;
		if(this.model.getExpirationTime() != null) {
			res = this.model.getExpirationTime().toGregorianCalendar().getTime();
		}
		return res;
	}



	public EndpointReferenceType getInitiator() throws WSAddressingException {
		EndpointReferenceType res = null;
		if(this.model.getAgreementInitiator() != null) {
			res = WSAddressing4AgreementFactory.newInstance().addMonitoringElmt2Description((AbsItfEndpointReferenceType)new com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) this.model.getAgreementInitiator(), this));
		}
		return res;
	}



	public EndpointReferenceType getResponder() throws WSAddressingException {
		EndpointReferenceType res = null;
		if(this.model.getAgreementResponder() != null) {
			return WSAddressing4AgreementFactory.newInstance().addMonitoringElmt2Description((AbsItfEndpointReferenceType)new com.ebmwebsourcing.wsstar.addressing.definition.impl.EndpointReferenceTypeImpl((com.ebmwebsourcing.wsstar.addressing.definition.org.w3._2005._08.addressing.EndpointReferenceType) this.model.getAgreementResponder(), this));
		}
		return res;
	}



	public AgreementRoleType getServiceProvider() {
		return this.model.getServiceProvider();
	}



	public String getTemplateId() {
		return this.model.getTemplateId();
	}



	public String getTemplateName() {
		return this.model.getTemplateName();
	}



	public void setExpirationTime(Date time) throws WSAgreementException {
		try {
			GregorianCalendar gCalendar = new GregorianCalendar();
			gCalendar.setTime(time);

			XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);

			this.model.setExpirationTime(xmlCalendar);
		} catch (DatatypeConfigurationException e) {
			throw new WSAgreementException(e);
		}
	}



	public void setInitiator(EndpointReferenceType initiator) {
		if(initiator != null) {
			this.model.setAgreementInitiator(((AbstractSchemaElementImpl)initiator).getModel());
		} else {
			this.model.setAgreementInitiator(null);
		}
	}



	public void setResponder(EndpointReferenceType responder) {
		if(responder != null) {
			this.model.setAgreementResponder(((AbstractSchemaElementImpl)responder).getModel());
		} else {
			this.model.setAgreementResponder(null);
		}
	}



	public void setServiceProvider(AgreementRoleType role) {
		this.model.setServiceProvider(role);
	}



	public void setTemplateId(String templateId) {
		this.model.setTemplateId(templateId);
	}



	public void setTemplateName(String templateName) {
		this.model.setTemplateName(templateName);
	}




}
