package com.ebmwebsourcing.agreement.definition.impl;

import java.util.logging.Logger;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.KPITargetType;

import com.ebmwebsourcing.agreement.definition.api.KPITarget;
import com.ebmwebsourcing.agreement.definition.api.ServiceLevelObjective;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;

public class ServiceLevelObjectiveImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ServiceLevelObjectiveType> implements ServiceLevelObjective {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ServiceLevelObjectiveImpl.class.getName());

	private KPITarget kpi;

	public ServiceLevelObjectiveImpl(
			final com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ServiceLevelObjectiveType model,
			final AbstractSchemaElementImpl parent)
	throws WSAgreementException {
		super(model, parent);

		if(this.model.getKPITarget() != null) {
			this.kpi = new KPITargetImpl(this.model.getKPITarget(), this);
		}
	}


	public KPITarget getKPITarget() {
		return this.kpi;
	}


	public void setKPITarget(KPITarget target) {
		this.model.setKPITarget((KPITargetType) ((AbstractSchemaElementImpl)target).getModel());
		this.kpi = target;
	}


	public KPITarget newKPITarget() throws WSAgreementException {
		return new KPITargetImpl(new KPITargetType(), this);
	}

}
