package com.ebmwebsourcing.agreement.definition.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.VariableSetType;
import com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.VariableType;

import com.ebmwebsourcing.agreement.definition.api.KPITarget;
import com.ebmwebsourcing.agreement.definition.api.ServiceDescription;
import com.ebmwebsourcing.agreement.definition.api.ServiceLevelObjective;
import com.ebmwebsourcing.agreement.definition.api.ServiceProperties;
import com.ebmwebsourcing.agreement.definition.api.Variable;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;

public class ServicePropertiesImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ServicePropertiesType> implements ServiceProperties {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ServicePropertiesImpl.class.getName());

	private List<Variable> variables = new ArrayList<Variable>();

	public ServicePropertiesImpl(
			final com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.ServicePropertiesType model,
			final AbstractSchemaElementImpl parent)
	throws WSAgreementException {
		super(model, parent);

		// get variables
		if(this.model.getVariableSet() != null) {
			for(VariableType var: this.model.getVariableSet().getVariable()) {
				this.variables.add(new VariableImpl(var, this));
			}
		}
	}



	public List<Variable> getVariables() {
		return this.variables;
	}

	public String getName() {
		return this.model.getName();
	}



	public String getServiceName() {
		return this.model.getServiceName();
	}



	public void setName(String name) {
		this.model.setName(name);
	}



	public void setServiceName(String servName) {
		this.model.setServiceName(servName);
	}


	public void addVariable(Variable variable) {
		if(variable != null) {
			if(this.model.getVariableSet() == null) {
				this.model.setVariableSet(new VariableSetType());
			}
			this.model.getVariableSet().getVariable().add((VariableType) ((AbstractSchemaElementImpl)variable).getModel());
			this.variables.add(variable);
		}
	}

	public void removeVariable(Variable variable) {
		if(variable != null) {
			if(this.model.getVariableSet() != null) {
				this.model.getVariableSet().getVariable().remove((VariableType) ((AbstractSchemaElementImpl)variable).getModel());
				this.variables.remove(variable);
			}
		}
	}


	public Variable newVariable() throws WSAgreementException {
		return new VariableImpl(new VariableType(), this);
	}



}
