package com.ebmwebsourcing.wsstar.dm.impl;

import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.dm.api.QoSMetrics;
import com.ebmwebsourcing.wsstar.dm.api.WSDMException;
import com.ebmwebsourcing.wsstar.dm.api.expression.QoSDuration;
import com.ebmwebsourcing.wsstar.dm.api.expression.QoSInteger;
import com.ebmwebsourcing.wsstar.dm.impl.expression.QoSDurationImpl;
import com.ebmwebsourcing.wsstar.dm.impl.expression.QoSIntegerImpl;
import com.ebmwebsourcing.wsstar.dm.org.oasis_open.docs.wsdm.mows_2.DurationMetric;
import com.ebmwebsourcing.wsstar.dm.org.oasis_open.docs.wsdm.mows_2.IntegerCounter;
import com.ebmwebsourcing.wsstar.dm.org.oasis_open.docs.wsdm.mows_2.OperationMetricType;

public class QoSMetricsImpl extends WSDMElementImpl<OperationMetricType> implements QoSMetrics {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private QoSInteger lastResponseSize = null;

	private QoSInteger lastRequestSize = null;

	private QoSInteger maxResponseSize = null;

	private QoSInteger maxRequestSize = null;

	private QoSInteger numberOfFailedRequests = null;

	private QoSInteger numberOfRequests = null;

	private QoSInteger numberOfSuccessfulRequests = null;

	private QoSDuration lastResponseTime = null;

	private QoSDuration maxResponseTime = null;

	private QoSDuration serviceTime = null;

	public QoSMetricsImpl(final OperationMetricType model) {
		super(model, null);
		this.lastResponseSize = new QoSIntegerImpl(this.model.getLastResponseSize(), this);
		this.lastRequestSize = new QoSIntegerImpl(this.model.getLastRequestSize(), this);
		this.maxResponseSize = new QoSIntegerImpl(this.model.getMaxResponseSize(), this);
		this.maxRequestSize = new QoSIntegerImpl(this.model.getMaxRequestSize(), this);
		this.numberOfFailedRequests = new QoSIntegerImpl(this.model.getNumberOfFailedRequests(), this);
		this.numberOfRequests = new QoSIntegerImpl(this.model.getNumberOfRequests(), this);
		this.numberOfSuccessfulRequests = new QoSIntegerImpl(this.model.getNumberOfSuccessfulRequests(), this);
		this.lastResponseTime = new QoSDurationImpl(this.model.getLastResponseTime(), this);
		this.maxResponseTime = new QoSDurationImpl(this.model.getMaxResponseTime(), this);
		this.serviceTime = new QoSDurationImpl(this.model.getServiceTime(), this);
	}

	/**
	 * @return the lastResponseSize
	 */
	public QoSInteger getLastResponseSize() {
		return this.lastResponseSize;
	}

	/**
	 * @param lastResponseSize
	 *            the lastResponseSize to set
	 * @throws WSDMException
	 */
	public void setLastResponseSize(final QoSInteger lastResponseSize) throws WSDMException {
		if (this.model.getLastResponseSize() == null) {
			this.model.setLastResponseSize(new IntegerCounter());
			this.lastResponseSize = new QoSIntegerImpl(this.model.getLastResponseSize(), this);
		}
		this.lastResponseSize.setAll(lastResponseSize);
	}

	/**
	 * @return the lastRequestSize
	 */
	public QoSInteger getLastRequestSize() {
		return this.lastRequestSize;
	}

	/**
	 * @param lastRequestSize
	 *            the lastRequestSize to set
	 * @throws WSDMException
	 */
	public void setLastRequestSize(final QoSInteger lastRequestSize) throws WSDMException {
		if (this.model.getLastRequestSize() == null) {
			this.model.setLastRequestSize(new IntegerCounter());
			this.lastRequestSize = new QoSIntegerImpl(this.model.getLastRequestSize(), this);
		}
		this.lastRequestSize.setAll(lastRequestSize);
	}

	/**
	 * @return the maxResponseSize
	 */
	public QoSInteger getMaxResponseSize() {
		return this.maxResponseSize;
	}

	/**
	 * @param maxResponseSize
	 *            the maxResponseSize to set
	 * @throws WSDMException
	 */
	public void setMaxResponseSize(final QoSInteger maxResponseSize) throws WSDMException {
		if (this.model.getMaxResponseSize() == null) {
			this.model.setMaxResponseSize(new IntegerCounter());
			this.maxResponseSize = new QoSIntegerImpl(this.model.getMaxResponseSize(), this);
		}
		this.maxResponseSize.setAll(maxResponseSize);
	}

	/**
	 * @return the maxRequestSize
	 */
	public QoSInteger getMaxRequestSize() {
		return this.maxRequestSize;
	}

	/**
	 * @param maxRequestSize
	 *            the maxRequestSize to set
	 * @throws WSDMException
	 */
	public void setMaxRequestSize(final QoSInteger maxRequestSize) throws WSDMException {
		if (this.model.getMaxRequestSize() == null) {
			this.model.setMaxRequestSize(new IntegerCounter());
			this.maxRequestSize = new QoSIntegerImpl(this.model.getMaxRequestSize(), this);
		}
		this.maxRequestSize.setAll(maxRequestSize);
	}

	/**
	 * @return the numberOfFailedRequests
	 */
	public QoSInteger getNumberOfFailedRequests() {
		return this.numberOfFailedRequests;
	}

	/**
	 * @param numberOfFailedRequests
	 *            the numberOfFailedRequests to set
	 * @throws WSDMException
	 */
	public void setNumberOfFailedRequests(final QoSInteger numberOfFailedRequests) throws WSDMException {
		if (this.model.getNumberOfFailedRequests() == null) {
			this.model.setNumberOfFailedRequests(new IntegerCounter());
			this.numberOfFailedRequests = new QoSIntegerImpl(this.model.getNumberOfFailedRequests(), this);
		}
		this.numberOfFailedRequests.setAll(numberOfFailedRequests);
	}

	/**
	 * @return the numberOfRequests
	 */
	public QoSInteger getNumberOfRequests() {
		return this.numberOfRequests;
	}

	/**
	 * @param numberOfRequests
	 *            the numberOfRequests to set
	 * @throws WSDMException
	 */
	public void setNumberOfRequests(final QoSInteger numberOfRequests) throws WSDMException {
		if (this.model.getNumberOfRequests() == null) {
			this.model.setNumberOfRequests(new IntegerCounter());
			this.numberOfRequests = new QoSIntegerImpl(this.model.getNumberOfRequests(), this);
		}
		this.numberOfRequests.setAll(numberOfRequests);
	}

	/**
	 * @return the numberOfSuccessfulRequests
	 */
	public QoSInteger getNumberOfSuccessfulRequests() {
		return this.numberOfSuccessfulRequests;
	}

	/**
	 * @param numberOfSuccessfulRequests
	 *            the numberOfSuccessfulRequests to set
	 * @throws WSDMException
	 */
	public void setNumberOfSuccessfulRequests(final QoSInteger numberOfSuccessfulRequests) throws WSDMException {
		if (this.model.getNumberOfSuccessfulRequests() == null) {
			this.model.setNumberOfSuccessfulRequests(new IntegerCounter());
			this.numberOfSuccessfulRequests = new QoSIntegerImpl(this.model.getNumberOfSuccessfulRequests(), this);
		}
		this.numberOfSuccessfulRequests.setAll(numberOfSuccessfulRequests);
	}

	/**
	 * @return the lastResponseTime
	 */
	public QoSDuration getLastResponseTime() {
		return this.lastResponseTime;
	}

	/**
	 * @param lastResponseTime
	 *            the lastResponseTime to set
	 * @throws WSDMException
	 */
	public void setLastResponseTime(final QoSDuration lastResponseTime) throws WSDMException {
		if (this.model.getLastResponseTime() == null) {
			this.model.setLastResponseTime(new DurationMetric());
			this.lastResponseTime = new QoSDurationImpl(this.model.getLastResponseTime(), this);
		}
		this.lastResponseTime.setAll(lastResponseTime);
	}

	/**
	 * @return the maxResponseTime
	 */
	public QoSDuration getMaxResponseTime() {
		return this.maxResponseTime;
	}

	/**
	 * @param maxResponseTime
	 *            the maxResponseTime to set
	 * @throws WSDMException
	 */
	public void setMaxResponseTime(final QoSDuration maxResponseTime) throws WSDMException {
		if (this.model.getMaxResponseTime() == null) {
			this.model.setMaxResponseTime(new DurationMetric());
			this.maxResponseTime = new QoSDurationImpl(this.model.getMaxResponseTime(), this);
		}
		this.maxResponseTime.setAll(maxResponseTime);
	}

	/**
	 * @return the serviceTime
	 */
	public QoSDuration getServiceTime() {
		return this.serviceTime;
	}

	/**
	 * @param serviceTime
	 *            the serviceTime to set
	 * @throws WSDMException
	 */
	public void setServiceTime(final QoSDuration serviceTime) throws WSDMException {
		if (this.model.getServiceTime() == null) {
			this.model.setServiceTime(new DurationMetric());
			this.serviceTime = new QoSDurationImpl(this.model.getServiceTime(), this);
		}
		this.serviceTime.setAll(serviceTime);
	}

	/**
	 * @return the portType
	 */
	public QName getPortType() {
		return this.model.getPortType();
	}

	/**
	 * @param portType
	 *            the portType to set
	 */
	public void setPortType(final QName portType) {
		this.model.setPortType(portType);
	}

	/**
	 * @return the operation
	 */
	public String getOperation() {
		return this.model.getOperationName();
	}

	/**
	 * @param operation
	 *            the operation to set
	 */
	public void setOperation(final String operation) {
		this.model.setOperationName(operation);
	}

	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}

	@Override
	public Map<QName, String> getOtherAttributes() throws XmlException {
		return this.model.getOtherAttributes();
	}

	public void addOtherElements(final Element arg0) {
		throw new NotImplementedException();
	}

}
