package com.ebmwebsourcing.wsstar.dm.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Import;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Output;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLImportException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription.WSDLVersionConstants;
import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.dm.api.WSDMDescription;
import com.ebmwebsourcing.wsstar.dm.api.WSDMException;


public class WSDMDescriptionImpl implements WSDMDescription {

	private WSDLReader reader = null;

	public WSDLReader getReader() throws WSDLException {
		if(reader == null) {
			reader = WSDLFactory.newInstance().newWSDLReader();
		}
		return reader;
	}

	private Description desc = null;

	public WSDMDescriptionImpl(final QName serviceName, final String endpointName) throws WSDMException {
		try {
			desc = WSDLFactory.newInstance().newDescription(WSDLVersionConstants.WSDL11);
			desc.setTargetNamespace(serviceName.getNamespaceURI());

			// Read wsdm desc
			URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource("wsdm.wsdl");
			final Description wsdm = getReader().read(wsdlUrl);


			// set name
			desc.setQName(new QName(serviceName.getNamespaceURI(), serviceName.getLocalPart() + "_Description"));

			// create wsdm import:
			final Import impt = desc.createImport();
			impt.setLocationURI(new URI("wsdm.wsdl"));
			impt.setNamespaceURI(wsdm.getTargetNamespace());
			desc.addImport(impt);


			// create service
			final Service service = desc.createService();
			service.setQName(serviceName);

			// create WSDM endpoint
			final Endpoint wsdmEndpoint = service.createEndpoint();
			wsdmEndpoint.setName(endpointName);
			wsdmEndpoint.setAddress(endpointName);
			wsdmEndpoint.setBinding(wsdm.getBinding(new QName(wsdm.getTargetNamespace(), "WSDMBinding")));


			// create Interceptor endpoint
			final Endpoint interceptorEndpoint = service.createEndpoint();
			interceptorEndpoint.setName(endpointName + "_Interceptor");
			interceptorEndpoint.setAddress(endpointName);
			interceptorEndpoint.setBinding(wsdm.getBinding(new QName(wsdm.getTargetNamespace(), "InterceptorBinding")));



			// add endpoint to service
			service.addEndpoint(wsdmEndpoint);
			service.addEndpoint(interceptorEndpoint);

			// add service to description
			desc.addService(service);

		} catch (final WSDLException e) {
			throw new WSDMException(e);
		} catch (final XmlException e) {
			throw new WSDMException(e);
		} catch (final WSDLImportException e) {
			throw new WSDMException(e);
		} catch (final URISyntaxException e) {
			throw new WSDMException(e);
		} catch (IOException e) {
			throw new WSDMException(e);
		}
	}



	public Description getDescription() {
		return desc;
	}

	public Document getDocument() throws WSDMException {
		Document res = null;
		try {
			res = WSDLFactory.newInstance().newWSDLWriter().getDocument(desc);
		} catch (final WSDLException e) {
			throw new WSDMException(e);
		}
		return res;
	}

	public static Document addManageabilityReferencesInInterfaceOfEndpoint(
			final Description desc, final QName serviceName, final String endpointName) throws WSDMException {
		Document doc = null;
		try {
			final Service service = desc.getService(serviceName);
			if(service == null) {
				throw new WSDMException("Service not found");
			}

			final Endpoint endpoint = service.getEndpoint(endpointName);
			if(endpoint == null) {
				throw new WSDMException("Endpoint not found");
			}

			final Binding binding = endpoint.getBinding();
			if(binding == null) {
				throw new WSDMException("Binding not found");
			}

			final InterfaceType itf = binding.getInterface();
			if(itf == null) {
				throw new WSDMException("Interface not found");
			}

			// add import: mows
			final Import impt = desc.createImport();
			impt.setLocationURI(new URI("http://docs.oasis-open.org/wsdm/mows-2.wsdl"));
			impt.setNamespaceURI("http://docs.oasis-open.org/wsdm/mows-2.wsdl");
			desc.addImport(impt);

			// add operation: GetManageabilityReferences
			final Operation op = itf.createOperation();
			op.setQName(new QName(itf.getQName().getNamespaceURI(), "GetManageabilityReferences"));
			itf.addOperation(op);

			final Input input = op.createInput();
			input.setName("GetManageabilityReferencesRequest");
			input.setMessageName(new QName("http://docs.oasis-open.org/wsdm/mows-2.wsdl", "GetManageabilityReferencesRequest"));
			op.setInput(input);

			final Output output = op.createOutput();
			output.setName("GetManageabilityReferencesResponse");
			output.setMessageName(new QName("http://docs.oasis-open.org/wsdm/mows-2.wsdl", "GetManageabilityReferencesResponse"));
			op.setOutput(output);

			doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(desc);
		} catch (final WSDLException e) {
			throw new WSDMException(e);
		} catch (final WSDLImportException e) {
			throw new WSDMException(e);
		} catch (final URISyntaxException e) {
			throw new WSDMException(e);
		}

		return doc;
	}

}
