/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.dm.impl;

import com.ebmwebsourcing.wsstar.dm.api.WSDMDescription;
import com.ebmwebsourcing.wsstar.dm.api.WSDMException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Import;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Output;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLImportException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfEndpoint;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfImport;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInput;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOutput;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfService;
import org.w3c.dom.Document;

public class WSDMDescriptionImpl
implements WSDMDescription {
    private WSDLReader reader = null;
    private Description desc = null;

    public WSDLReader getReader() throws WSDLException {
        if (this.reader == null) {
            this.reader = WSDLFactory.newInstance().newWSDLReader();
        }
        return this.reader;
    }

    public WSDMDescriptionImpl(QName serviceName, String endpointName) throws WSDMException {
        try {
            this.desc = WSDLFactory.newInstance().newDescription(AbsItfDescription.WSDLVersionConstants.WSDL11);
            this.desc.setTargetNamespace(serviceName.getNamespaceURI());
            URL wsdlUrl = Thread.currentThread().getContextClassLoader().getResource("wsdm.wsdl");
            Description wsdm = this.getReader().read(wsdlUrl);
            this.desc.setQName(new QName(serviceName.getNamespaceURI(), serviceName.getLocalPart() + "_Description"));
            Import impt = (Import)this.desc.createImport();
            impt.setLocationURI(new URI("wsdm.wsdl"));
            impt.setNamespaceURI(wsdm.getTargetNamespace());
            this.desc.addImport((AbsItfImport)impt);
            Service service = (Service)this.desc.createService();
            service.setQName(serviceName);
            Endpoint wsdmEndpoint = (Endpoint)service.createEndpoint();
            wsdmEndpoint.setName(endpointName);
            wsdmEndpoint.setAddress(endpointName);
            wsdmEndpoint.setBinding(wsdm.getBinding(new QName(wsdm.getTargetNamespace(), "WSDMBinding")));
            Endpoint interceptorEndpoint = (Endpoint)service.createEndpoint();
            interceptorEndpoint.setName(endpointName + "_Interceptor");
            interceptorEndpoint.setAddress(endpointName);
            interceptorEndpoint.setBinding(wsdm.getBinding(new QName(wsdm.getTargetNamespace(), "InterceptorBinding")));
            service.addEndpoint((AbsItfEndpoint)wsdmEndpoint);
            service.addEndpoint((AbsItfEndpoint)interceptorEndpoint);
            this.desc.addService((AbsItfService)service);
        }
        catch (WSDLException e) {
            throw new WSDMException(e);
        }
        catch (XmlException e) {
            throw new WSDMException(e);
        }
        catch (WSDLImportException e) {
            throw new WSDMException(e);
        }
        catch (URISyntaxException e) {
            throw new WSDMException(e);
        }
        catch (IOException e) {
            throw new WSDMException(e);
        }
    }

    public Description getDescription() {
        return this.desc;
    }

    public Document getDocument() throws WSDMException {
        Document res = null;
        try {
            res = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.desc);
        }
        catch (WSDLException e) {
            throw new WSDMException(e);
        }
        return res;
    }

    public static Document addManageabilityReferencesInInterfaceOfEndpoint(Description desc, QName serviceName, String endpointName) throws WSDMException {
        Document doc = null;
        try {
            Service service = (Service)desc.getService(serviceName);
            if (service == null) {
                throw new WSDMException("Service not found");
            }
            Endpoint endpoint = (Endpoint)service.getEndpoint(endpointName);
            if (endpoint == null) {
                throw new WSDMException("Endpoint not found");
            }
            Binding binding = (Binding)endpoint.getBinding();
            if (binding == null) {
                throw new WSDMException("Binding not found");
            }
            InterfaceType itf = (InterfaceType)binding.getInterface();
            if (itf == null) {
                throw new WSDMException("Interface not found");
            }
            Import impt = (Import)desc.createImport();
            impt.setLocationURI(new URI("http://docs.oasis-open.org/wsdm/mows-2.wsdl"));
            impt.setNamespaceURI("http://docs.oasis-open.org/wsdm/mows-2.wsdl");
            desc.addImport((AbsItfImport)impt);
            Operation op = (Operation)itf.createOperation();
            op.setQName(new QName(itf.getQName().getNamespaceURI(), "GetManageabilityReferences"));
            itf.addOperation((AbsItfOperation)op);
            Input input = (Input)op.createInput();
            input.setName("GetManageabilityReferencesRequest");
            input.setMessageName(new QName("http://docs.oasis-open.org/wsdm/mows-2.wsdl", "GetManageabilityReferencesRequest"));
            op.setInput((AbsItfInput)input);
            Output output = (Output)op.createOutput();
            output.setName("GetManageabilityReferencesResponse");
            output.setMessageName(new QName("http://docs.oasis-open.org/wsdm/mows-2.wsdl", "GetManageabilityReferencesResponse"));
            op.setOutput((AbsItfOutput)output);
            doc = WSDLFactory.newInstance().newWSDLWriter().getDocument(desc);
        }
        catch (WSDLException e) {
            throw new WSDMException(e);
        }
        catch (WSDLImportException e) {
            throw new WSDMException(e);
        }
        catch (URISyntaxException e) {
            throw new WSDMException(e);
        }
        return doc;
    }
}

