/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.wsstar.dm;

import java.net.URL;

import javax.xml.namespace.QName;

import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.dm.api.QoSMetrics;
import com.ebmwebsourcing.wsstar.dm.api.WSDMException;
import com.ebmwebsourcing.wsstar.dm.api.WSDMReader;
import com.ebmwebsourcing.wsstar.dm.api.WSDMWriter;
import com.ebmwebsourcing.wsstar.dm.api.expression.QoSDuration;
import com.ebmwebsourcing.wsstar.dm.api.expression.QoSInteger;


/**
 * This abstract class defines a factory API that enables applications to obtain
 * a WSDMFactory capable of producing new Definitions, new WSDLReaders, and new
 * WSDLWriters.
 *
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 *
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class WSDMFactory {

	/**
	 * Get a new instance of a WSDMFactory. This method follows (almost) the
	 * same basic sequence of steps that JAXP follows to determine the
	 * fully-qualified class name of the class which implements WSDMFactory.
	 * <p>
	 * The steps in order are:
	 * <ol>
	 * <li>Check the property file
	 * META-INF/services/javax.wsdl.factory.WSDLFactory.</li>
	 * <li>Check the javax.wsdl.factory.WSDLFactory system property.</li>
	 * <li>Check the lib/wsdl.properties file in the JRE directory. The key will
	 * have the same name as the above system property.</li>
	 * <li>Use the default class name provided by the implementation.</li>
	 * </ol>
	 * <p>
	 * Once an instance of a WSDMFactory is obtained, invoke newDefinition(),
	 * newWSDLReader(), or newWSDLWriter(), to create the desired instances.
	 */
	public static WSDMFactory newInstance() throws WSDMException {
		return new WSDMFactoryImpl();
	}

	/**
	 * Create a new instance of a QoSMetrics.
	 * @throws WSDMException
	 */
	public abstract QoSMetrics newQoSMetrics() throws WSDMException;

	/**
	 * Create a new instance of a QoSDuration.
	 * @throws WSDMException
	 */
	public abstract QoSDuration newQoSDuration() throws WSDMException;

	/**
	 * Create a new instance of a QoSInteger.
	 * @throws WSDMException
	 */
	public abstract QoSInteger newQoSInteger() throws WSDMException;

	/**
	 * Create a new instance of a WSDLReaderImpl.
	 * @throws WSDMException
	 */
	public abstract WSDMReader newWSDMReader() throws WSDMException;

	/**
	 * Create a new instance of a WSDLWriterImpl.
	 * @throws WSDMException
	 */
	public abstract WSDMWriter newWSDMWriter() throws WSDMException;


	public abstract Document createWSDMWSDL(QName service, String endpoint) throws WSDMException;

	public abstract Document addManageabilityReferencesInInterfaceOfEndpoint(URL wsdl, QName serviceName, String endpoint) throws WSDMException;
}
