package com.ebmwebsourcing.wsstar.dm.convertor;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.EndpointReferenceType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.MonitoringPropertiesType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.ReferenceParametersType;
import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.impl.WSAddressing4AgreementFactory;
import com.ebmwebsourcing.agreement.definition.api.Location;
import com.ebmwebsourcing.agreement.definition.api.Variable;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.agreement.definition.impl.VariableImpl;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.agreement.service.api.MonitoringConvertor;
import com.ebmwebsourcing.wsstar.qml.WSQMLFactory;
import com.ebmwebsourcing.wsstar.qml.api.QOSDimension;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;

public class AgreementConvertor implements MonitoringConvertor {

    private static List<Variable> variables = new ArrayList<Variable>();

    AgreementConvertor() throws WSAgreementException {
        variables.add(createLatencyVariable());
        variables.add(createAvailabilityVariable());
    }

    public List<Variable> convertMonitoringInformationsToVariableProperties() throws WSAgreementException {
        return variables;
    }

    
    private Variable createLatencyVariable() throws WSAgreementException {
        Variable latency = null;
        try {
            latency = new VariableImpl(new com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.VariableType(), null);
            latency.setName("latency");
            latency.setMetric(new URI("http://purl.oclc.org/NET/muo/ucum/unit/time/second"));
            
            // set location
            Location location = latency.newLocation();
            latency.setLocation(location);
            EndpointReferenceType address = WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType();
            address.setAddress("");
            location.setAddress(address);
            ReferenceParametersType ref = address.newReferenceParameters();
            address.setReferenceParameters(ref);
            MonitoringPropertiesType monprops = ref.newMonitoringPropertiesType();
            ref.setMonitoringPropertiesType(monprops);
            
            Properties properties = new Properties();
            properties.put("mode", "pull");
            properties.put("operation", "speed");
            monprops.setProperty(properties);
            
            QOSDimension dim = WSQMLFactory.newInstance().newQOSDimension();
            dim.setSemanticConcept("http://www-rocq.inria.fr/arles/semeuse/SemeuseQoSOntology/QoSServiceOntology.owl#ResponseTime");
            location.setQOSDimension(dim);
        } catch (URISyntaxException e) {
            throw new WSAgreementException(e);
        } catch (WSAddressingException e) {
            throw new WSAgreementException(e);
        } catch (WSQMLException e) {
            throw new WSAgreementException(e);
        }
        return latency;
    }
    
    
    private Variable createAvailabilityVariable() throws WSAgreementException {
        Variable availability = null;
        try {
            availability = new VariableImpl(new com.ebmwebsourcing.wsstar.agreement.definition.org.ggf.schemas.graap.agreement.VariableType(), null);
            availability.setName("availability");
            availability.setMetric(new URI("http://purl.oclc.org/NET/muo/ucum/unit/fraction/percent"));
            
            // set location
            Location location = availability.newLocation();
            availability.setLocation(location);
            EndpointReferenceType address = WSAddressing4AgreementFactory.newInstance().newEndpointReferenceType();
            address.setAddress("");
            location.setAddress(address);
            ReferenceParametersType ref = address.newReferenceParameters();
            address.setReferenceParameters(ref);
            MonitoringPropertiesType monprops = ref.newMonitoringPropertiesType();
            ref.setMonitoringPropertiesType(monprops);
            
            Properties properties = new Properties();
            properties.put("mode", "pull");
            properties.put("operation", "speed");
            monprops.setProperty(properties);
            
            QOSDimension dim = WSQMLFactory.newInstance().newQOSDimension();
            dim.setSemanticConcept("http://www-rocq.inria.fr/arles/semeuse/SemeuseQoSOntology/QoSServiceOntology.owl#Availability");
            location.setQOSDimension(dim);
        } catch (URISyntaxException e) {
            throw new WSAgreementException(e);
        } catch (WSAddressingException e) {
            throw new WSAgreementException(e);
        } catch (WSQMLException e) {
            throw new WSAgreementException(e);
        }
        return availability;
    }
}
