/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.wsstar.dm.impl;

import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;

import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.dm.api.QoSMetrics;
import com.ebmwebsourcing.wsstar.dm.api.WSDMException;
import com.ebmwebsourcing.wsstar.dm.api.WSDMReader;
import com.ebmwebsourcing.wsstar.dm.org.oasis_open.docs.wsdm.mows_2.OperationMetricType;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDMReaderImpl implements WSDMReader {


	private WSDMJAXBContext context = null;


	/*
	 * Private object initializations
	 */
	public WSDMReaderImpl() throws WSDMException {
		context = new WSDMJAXBContext();
	}

	public WSDMReaderImpl(List<Class> addedObjectFactories) throws WSDMException {
		context = new WSDMJAXBContext(addedObjectFactories); 
	}

	private OperationMetricType convertStream2WSDMMetric(final Source wsdmDescriptorStream)
	throws WSDMException {

		try {
			// TODO : Check if it is a Thread safe method
			final JAXBElement<OperationMetricType> wsdmBinding = this.context.getJaxbContext().createUnmarshaller()
			.unmarshal(wsdmDescriptorStream, OperationMetricType.class);

			return wsdmBinding.getValue();

		} catch (final JAXBException e) {
			throw new WSDMException(
					"Failed to build Java bindings from WSDL descriptor XML document", e);
		}
	}


	public QoSMetrics readOperationMetric(final Document wsdlDocument) throws WSDMException {
		QoSMetrics res = null;
		OperationMetricType desc = this.convertStream2WSDMMetric(new DOMSource(wsdlDocument));
		res = new QoSMetricsImpl(desc);
		return res;
	}

}
