/**
 * easyWSDL - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.wsstar.dm.impl;

import java.io.StringWriter;
import java.util.List;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.w3c.dom.Document;

import com.ebmwebsourcing.wsstar.dm.api.QoSMetrics;
import com.ebmwebsourcing.wsstar.dm.api.WSDMException;
import com.ebmwebsourcing.wsstar.dm.api.WSDMWriter;
import com.ebmwebsourcing.wsstar.dm.org.oasis_open.docs.wsdm.mows_2.OperationMetricType;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDMWriterImpl implements WSDMWriter {


    /**
     * WSDL 2.0 Namespace
     */
    public static final String WSDM_MOWS2_NAMESPACE = "http://docs.oasis-open.org/wsdm/mows-2.xsd";

    /**
     * WSDL 2.0 root tag
     */
    public static final String WSDM_MOWS2_ROOT_TAG = "resourceProperties";


    private WSDMJAXBContext context = null;


    /*
     * Private object initializations
     */
    public WSDMWriterImpl() throws WSDMException {
    	context = new WSDMJAXBContext();
    }

    public WSDMWriterImpl(List<Class> addedObjectFactories) throws WSDMException {
    	context = new WSDMJAXBContext(addedObjectFactories);
    }

    /**
     * Build the XML nodes from the WSDL descriptor in Java classes form.
     *
     * @param EndpointReferenceDescriptorClass
     *            The EndpointReference Descriptor root class
     * @param EndpointReferenceDescriptorNode
     *            The XML Node to fill with the EndpointReference descriptor XML
     *            nodes
     */
    @SuppressWarnings("unchecked")
    private Document convertWSDMOperationMetric2DOMElement(final OperationMetricType wsdmDescriptor)
    throws WSDMException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

            // TODO : Check if it is a Thread safe method
            final JAXBElement element = new JAXBElement(new QName(WSDM_MOWS2_NAMESPACE,
                    WSDM_MOWS2_ROOT_TAG), wsdmDescriptor.getClass(), wsdmDescriptor);

            this.context.getJaxbContext().createMarshaller().marshal(element, doc);

        } catch (final JAXBException ex) {
            throw new WSDMException(
                    "Failed to build XML binding from WSDL descriptor Java classes", ex);
        } catch (final ParserConfigurationException ex) {
            throw new WSDMException(
                    "Failed to build XML binding from WSDL descriptor Java classes", ex);

        }
        return doc;
    }

    /**
     * Build the XML String from the WSDL descriptor in Java classes form.
     *
     * @param WSDLDescriptorClass
     *            The WSDL Descriptor root class
     * @return The String to fill with the WSDL descriptor XML
     * @throws WSDLException
     *             The exception raised during the marshaller creation or the
     *             exception raised during the build of the XML string.
     */
    @SuppressWarnings("unchecked")
    private String convertWSDMOperationMetric2String(final OperationMetricType wsdmDescriptor)
    throws WSDMException {

        try {
            final StringWriter stringWriter = new StringWriter();
            // TODO : Check if it is a Thread safe method

            final JAXBElement element = new JAXBElement(new QName(WSDM_MOWS2_NAMESPACE,
                    WSDM_MOWS2_ROOT_TAG), wsdmDescriptor.getClass(), wsdmDescriptor);

            this.context.getJaxbContext().createMarshaller().marshal(element, stringWriter);

            return stringWriter.toString();
        } catch (final JAXBException e) {
            throw new WSDMException(
                    "Failed to build XML binding from Agreement descriptor Java classes", e);
        }
    }

    public Document getDocument(final QoSMetrics wsdmDef) throws WSDMException {
        Document doc = null;
        if (wsdmDef != null) {
            doc = this.convertWSDMOperationMetric2DOMElement(((QoSMetricsImpl) wsdmDef).getModel());
        }
        return doc;
    }

    public String writeOperationMetric(final QoSMetrics wsdmDef) throws WSDMException {
        String res = null;
        if (wsdmDef != null) {
            res = this.convertWSDMOperationMetric2String(((QoSMetricsImpl) wsdmDef).getModel());
        }
        return res;
    }
}
