package com.ebmwebsourcing.wsstar.dm.impl.expression;

import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

import org.apache.commons.lang.NotImplementedException;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.dm.api.WSDMException;
import com.ebmwebsourcing.wsstar.dm.api.expression.QoSDuration;
import com.ebmwebsourcing.wsstar.dm.impl.WSDMElementImpl;
import com.ebmwebsourcing.wsstar.dm.org.oasis_open.docs.wsdm.mows_2.DurationMetric;

public class QoSDurationImpl extends QosExpressionImpl<DurationMetric, Duration> implements QoSDuration {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public QoSDurationImpl(final DurationMetric model, final WSDMElementImpl parent) {
		super(model, parent);
	}

	public Duration getDuration() {
		return this.model.getDuration();
	}

	public Date getLastUpdated() {
		Date res = null;
		if (this.model.getLastUpdated() != null) {
			res = this.model.getLastUpdated().toGregorianCalendar().getTime();
		}
		return res;
	}

	public Date getResetAt() {
		Date res = null;
		if (this.model.getResetAt() != null) {
			res = this.model.getResetAt().toGregorianCalendar().getTime();
		}
		return res;
	}

	public void setDuration(final Duration d) {
		this.model.setDuration(d);
	}

	public void setLastUpdated(final Date d) throws WSDMException {
		if (d != null) {
			try {
				final GregorianCalendar gCalendar = new GregorianCalendar();
				gCalendar.setTime(d);

				final XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);

				this.model.setLastUpdated(xmlCalendar);
			} catch (final DatatypeConfigurationException e) {
				throw new WSDMException(e);
			}
		}
	}

	public void setResetAt(final Date d) throws WSDMException {
		if (d != null) {
			try {
				final GregorianCalendar gCalendar = new GregorianCalendar();
				gCalendar.setTime(d);

				final XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);

				this.model.setResetAt(xmlCalendar);
			} catch (final DatatypeConfigurationException e) {
				throw new WSDMException(e);
			}
		}
	}

	public Duration getValue() {
		return this.model.getValue();
	}

	public void setValue(final Duration value) {
		this.model.setValue(value);
	}

	public void setAll(final QoSDuration qd) throws WSDMException {
		this.setDuration(qd.getDuration());
		this.setLastUpdated(qd.getLastUpdated());
		this.setResetAt(qd.getResetAt());
		this.setValue(qd.getValue());
	}

	public void addOtherElements(final Element arg0) {
		throw new NotImplementedException();
	}

}
