/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Element;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class TopicExpressionTypeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType> implements TopicExpressionType {

	private static final long serialVersionUID = 1L;

	public TopicExpressionTypeImpl(final com.ebmwebsourcing.wsstar.notification.definition.base.TopicExpressionType model, final AbstractSchemaElementImpl<?> parent) throws WSNotificationException {
		super(model, parent);
	}

	public String getDialect() {
		return this.model.getDialect();
	}

	public void setDialect(final String value) {
		this.model.setDialect(value);
	}

	public String getContent() {
		String res = null;
		if (this.model.getContent() != null && this.model.getContent().size() > 0) {
			res = this.model.getContent().get(0).toString().trim();
		}
		return res;
	}

	public void setContent(final String value) {
		final List<Object> objFromModel = this.model.getContent();

		if (objFromModel != null) {

			if (objFromModel.size() > 0) {
				objFromModel.clear();
			}

			objFromModel.add(0, value.trim());
		}
	}

	public List<QName> getTopicNameSpace() throws WSNotificationException {
		final Map<QName, String> objFromModel = this.model.getOtherAttributes();
		return objFromModel != null ? new ArrayList<QName>(this.model.getOtherAttributes().keySet()) : null;
	}

	public void addTopicNameSpace(final String prefix, final String uri) throws WSNotificationException {
		final Map<QName, String> objFromModel = this.model.getOtherAttributes();
		if (objFromModel != null) {
			this.model.getOtherAttributes().put(new QName(uri, prefix), "xmlns");
		}
	}

	public void removeTopicNSFromModel() {
		final Map<QName, String> objFromModel = this.model.getOtherAttributes();
		if (objFromModel != null) {
			objFromModel.clear();
		}
	}

	public void addOtherElements(final Element elmt) {
		throw new NotImplementedException();
	}

	public List<Element> getOtherElements() throws XmlException {
		throw new NotImplementedException();
	}
}