package com.ebmwebsourcing.wsstar.notification.definition.basenotification.impl;

import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.RenewResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;

public class RenewResponseImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.notification.definition.base.RenewResponse> implements
		RenewResponse {

	private static final long serialVersionUID = 1L;

	public RenewResponseImpl(com.ebmwebsourcing.wsstar.notification.definition.base.RenewResponse model, AbstractSchemaElementImpl<?> parent) {
		super(model,parent);
	}
	
	public Date getCurrentTime() {
		Date result = null;
		XMLGregorianCalendar currentTimeFromModel = this.model.getCurrentTime();
		if (currentTimeFromModel != null)
			result = currentTimeFromModel.toGregorianCalendar().getTime();
		return result;
	}

	public Date getTerminationTime() {
		Date result = null;
		XMLGregorianCalendar terminationTimeFromModel = this.model.getTerminationTime();
		if (terminationTimeFromModel != null)
			result = terminationTimeFromModel.toGregorianCalendar().getTime();
		return result;
	}

	public void setCurrentTime(Date value) throws WSNotificationException {
		final GregorianCalendar gCalendar = new GregorianCalendar();
		gCalendar.setTime(value);
		XMLGregorianCalendar xmlCalendar;
		try {
			xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
		} catch (DatatypeConfigurationException e) {
			throw new WSNotificationException(e);
		}		
		this.model.setCurrentTime(xmlCalendar);			

	}

	public void setTerminationTime(Date value) throws WSNotificationException {
		final GregorianCalendar gCalendar = new GregorianCalendar();
		gCalendar.setTime(value);
		XMLGregorianCalendar xmlCalendar;
		try {
			xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
			this.model.setTerminationTime(xmlCalendar);			
		} catch (final DatatypeConfigurationException e) {
			throw new WSNotificationException(e);
		}
	}
}
